/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.codahale.metrics.internal.BlockingExecTimingInterceptor;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;

public class RequestTimingHandler
implements Handler {
    private final CodaHaleMetricsModule.Config config;

    public RequestTimingHandler(CodaHaleMetricsModule.Config config) {
        this.config = config;
    }

    public void handle(Context context) throws Exception {
        MetricRegistry metricRegistry = (MetricRegistry)context.get(MetricRegistry.class);
        Request request = context.getRequest();
        BlockingExecTimingInterceptor blockingExecTimingInterceptor = new BlockingExecTimingInterceptor(metricRegistry, request, this.config);
        Execution.current().addInterceptor((ExecInterceptor)blockingExecTimingInterceptor, () -> {
            String tag = this.buildRequestTimerTag(request.getPath(), request.getMethod().getName());
            Timer.Context timer = metricRegistry.timer(tag).time();
            context.onClose(requestOutcome -> {
                metricRegistry.counter(String.valueOf(requestOutcome.getResponse().getStatus().getCode()).substring(0, 1) + "xx-responses").inc();
                timer.stop();
            });
            context.next();
        });
    }

    private String buildRequestTimerTag(String requestPath, String requestMethod) {
        String tagName;
        String string = tagName = requestPath.equals("") ? "root" : requestPath.replace("/", ".");
        if (this.config.getRequestMetricGroups() != null) {
            for (Map.Entry<String, String> metricGrouping : this.config.getRequestMetricGroups().entrySet()) {
                if (!requestPath.matches(metricGrouping.getValue())) continue;
                tagName = metricGrouping.getKey();
                break;
            }
        }
        return tagName + "." + requestMethod.toLowerCase() + "-requests";
    }
}

