/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import ratpack.func.Function;

public class MetricRegistryJsonMapper
implements Function<MetricRegistry, ByteBuf> {
    private final ObjectMapper mapper;
    private final ByteBufAllocator byteBufAllocator;

    public MetricRegistryJsonMapper(ByteBufAllocator byteBufAllocator, MetricFilter filter) {
        this.byteBufAllocator = byteBufAllocator;
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, filter));
    }

    public ByteBuf apply(MetricRegistry metricRegistry) throws Exception {
        ByteBuf byteBuf = this.byteBufAllocator.ioBuffer();
        try {
            ByteBufOutputStream out = new ByteBufOutputStream(byteBuf);
            this.mapper.writeValue((OutputStream)out, (Object)metricRegistry);
            return byteBuf;
        }
        catch (Exception e) {
            byteBuf.release();
            throw e;
        }
    }
}

