/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.codahale.metrics.internal.RegexMetricFilter;

public class JmxReporterProvider
implements Provider<JmxReporter> {
    private final MetricRegistry metricRegistry;
    private final CodaHaleMetricsModule.Config config;

    @Inject
    public JmxReporterProvider(MetricRegistry metricRegistry, CodaHaleMetricsModule.Config config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public JmxReporter get() {
        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry);
        this.config.getJmx().ifPresent(jmx -> {
            if (jmx.getIncludeFilter() != null || jmx.getExcludeFilter() != null) {
                builder.filter((MetricFilter)new RegexMetricFilter(jmx.getIncludeFilter(), jmx.getExcludeFilter()));
            }
        });
        return builder.build();
    }
}

