/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.codahale.metrics.Graphite;
import ratpack.codahale.metrics.internal.RegexMetricFilter;

public class GraphiteReporterProvider
implements Provider<GraphiteReporter> {
    private final MetricRegistry metricRegistry;
    private final CodaHaleMetricsModule.Config config;

    @Inject
    public GraphiteReporterProvider(MetricRegistry metricRegistry, CodaHaleMetricsModule.Config config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public GraphiteReporter get() {
        Optional<Graphite> graphite = this.config.getGraphite();
        boolean enabled = graphite.map(Graphite::isEnabled).orElse(false);
        if (!enabled) {
            return null;
        }
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry);
        graphite.ifPresent(input -> {
            if (input.getIncludeFilter() != null || input.getExcludeFilter() != null) {
                builder.filter((MetricFilter)new RegexMetricFilter(input.getIncludeFilter(), input.getExcludeFilter()));
            }
            if (input.getPrefix() != null) {
                builder.prefixedWith(input.getPrefix());
            }
            if (input.getDurationUnit() != null) {
                builder.convertDurationsTo(input.getDurationUnit());
            }
            if (input.getRateUnit() != null) {
                builder.convertRatesTo(input.getRateUnit());
            }
        });
        return builder.build(graphite.get().getSender());
    }
}

