/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.codahale.metrics.internal.RegexMetricFilter;

public class CsvReporterProvider
implements Provider<CsvReporter> {
    private final MetricRegistry metricRegistry;
    private final CodaHaleMetricsModule.Config config;

    @Inject
    public CsvReporterProvider(MetricRegistry metricRegistry, CodaHaleMetricsModule.Config config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public CsvReporter get() {
        if (this.config.getCsv().isPresent()) {
            CodaHaleMetricsModule.Config.Csv csv = this.config.getCsv().get();
            CsvReporter.Builder builder = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry);
            if (csv.getIncludeFilter() != null || csv.getExcludeFilter() != null) {
                builder.filter((MetricFilter)new RegexMetricFilter(csv.getIncludeFilter(), csv.getExcludeFilter()));
            }
            return builder.build(csv.getReportDirectory());
        }
        return null;
    }
}

