/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.codahale.metrics.internal.RegexMetricFilter;

public class ConsoleReporterProvider
implements Provider<ConsoleReporter> {
    private final MetricRegistry metricRegistry;
    private final CodaHaleMetricsModule.Config config;

    @Inject
    public ConsoleReporterProvider(MetricRegistry metricRegistry, CodaHaleMetricsModule.Config config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public ConsoleReporter get() {
        ConsoleReporter.Builder builder = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry);
        this.config.getConsole().ifPresent(console -> {
            if (console.getIncludeFilter() != null || console.getExcludeFilter() != null) {
                builder.filter((MetricFilter)new RegexMetricFilter(console.getIncludeFilter(), console.getExcludeFilter()));
            }
        });
        return builder.build();
    }
}

