/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import ratpack.codahale.metrics.CodaHaleMetricsModule;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Block;
import ratpack.http.Request;

public class BlockingExecTimingInterceptor
implements ExecInterceptor {
    private final MetricRegistry metricRegistry;
    private final Request request;
    private final CodaHaleMetricsModule.Config config;

    public BlockingExecTimingInterceptor(MetricRegistry metricRegistry, Request request, CodaHaleMetricsModule.Config config) {
        this.metricRegistry = metricRegistry;
        this.request = request;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Execution execution, ExecInterceptor.ExecType type, Block continuation) throws Exception {
        if (type == ExecInterceptor.ExecType.BLOCKING) {
            String tag = this.buildBlockingTimerTag(this.request.getPath(), this.request.getMethod().getName());
            Timer.Context timer = this.metricRegistry.timer(tag).time();
            try {
                continuation.execute();
            }
            finally {
                timer.stop();
            }
        } else {
            continuation.execute();
        }
    }

    private String buildBlockingTimerTag(String requestPath, String requestMethod) {
        String tagName;
        String string = tagName = requestPath.equals("") ? "root" : requestPath.replace("/", ".");
        if (this.config.getRequestMetricGroups() != null) {
            for (Map.Entry<String, String> metricGrouping : this.config.getRequestMetricGroups().entrySet()) {
                if (!requestPath.matches(metricGrouping.getValue())) continue;
                tagName = metricGrouping.getKey();
                break;
            }
        }
        return tagName + "." + requestMethod.toLowerCase() + "-blocking";
    }
}

