/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.Marker;
import ratpack.codahale.metrics.Graphite;
import ratpack.codahale.metrics.internal.ConsoleReporterProvider;
import ratpack.codahale.metrics.internal.CsvReporterProvider;
import ratpack.codahale.metrics.internal.GaugeTypeListener;
import ratpack.codahale.metrics.internal.GraphiteReporterProvider;
import ratpack.codahale.metrics.internal.JmxReporterProvider;
import ratpack.codahale.metrics.internal.MeteredMethodInterceptor;
import ratpack.codahale.metrics.internal.MetricRegistryPeriodicPublisher;
import ratpack.codahale.metrics.internal.MetricsBroadcaster;
import ratpack.codahale.metrics.internal.RequestTimingHandler;
import ratpack.codahale.metrics.internal.Slf4jReporterProvider;
import ratpack.codahale.metrics.internal.TimedMethodInterceptor;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.server.Service;
import ratpack.server.StartEvent;
import ratpack.util.Exceptions;

public class CodaHaleMetricsModule
extends ConfigurableModule<Config> {
    public static final String RATPACK_METRIC_REGISTRY = "ratpack-metrics";

    protected void configure() {
        SharedMetricRegistries.remove((String)RATPACK_METRIC_REGISTRY);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)RATPACK_METRIC_REGISTRY);
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Metered.class), new MethodInterceptor[]{this.injected(new MeteredMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Timed.class), new MethodInterceptor[]{this.injected(new TimedMethodInterceptor())});
        this.bindListener(Matchers.any(), this.injected(new GaugeTypeListener()));
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ConsoleReporter.class).toProvider(ConsoleReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(Slf4jReporter.class).toProvider(Slf4jReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(CsvReporter.class).toProvider(CsvReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(GraphiteReporter.class).toProvider(GraphiteReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryPeriodicPublisher.class).in(Scopes.SINGLETON);
        this.bind(MetricsBroadcaster.class).in(Scopes.SINGLETON);
        this.bind(Startup.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toProvider(HandlerDecoratorProvider.class);
    }

    private <T> T injected(T instance) {
        this.requestInjection(instance);
        return instance;
    }

    private static class HandlerDecoratorProvider
    implements Provider<HandlerDecorator> {
        private Config config;

        @Inject
        public HandlerDecoratorProvider(Config config) {
            this.config = config;
        }

        public HandlerDecorator get() {
            return HandlerDecorator.prepend((Handler)new RequestTimingHandler(this.config));
        }
    }

    private static class Startup
    implements Service {
        private final Config config;
        private final Injector injector;

        @Inject
        public Startup(Config config, Injector injector) {
            this.config = config;
            this.injector = injector;
        }

        public void onStart(StartEvent event) throws Exception {
            this.config.getJmx().ifPresent(jmx -> {
                if (jmx.isEnabled()) {
                    ((JmxReporter)this.injector.getInstance(JmxReporter.class)).start();
                }
            });
            this.config.getConsole().ifPresent(console -> {
                if (console.isEnabled()) {
                    ((ConsoleReporter)this.injector.getInstance(ConsoleReporter.class)).start(console.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getSlf4j().ifPresent(slf4j -> {
                if (slf4j.isEnabled()) {
                    ((Slf4jReporter)this.injector.getInstance(Slf4jReporter.class)).start(slf4j.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getCsv().ifPresent(csv -> {
                if (csv.isEnabled()) {
                    ((CsvReporter)this.injector.getInstance(CsvReporter.class)).start(csv.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getGraphite().ifPresent(graphite -> {
                if (graphite.isEnabled()) {
                    ((GraphiteReporter)this.injector.getInstance(GraphiteReporter.class)).start(graphite.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            if (this.config.isJvmMetrics()) {
                MetricRegistry metricRegistry = (MetricRegistry)this.injector.getInstance(MetricRegistry.class);
                metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
                metricRegistry.registerAll((MetricSet)new ThreadStatesGaugeSet());
                metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
            }
        }
    }

    public static class Config {
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(30L);
        private boolean jvmMetrics;
        private Map<String, String> requestMetricGroups;
        private Optional<Jmx> jmx = Optional.empty();
        private Optional<Console> console = Optional.empty();
        private Optional<WebSocket> webSocket = Optional.empty();
        private Optional<Csv> csv = Optional.empty();
        private Optional<Slf4j> slf4j = Optional.empty();
        private Optional<Graphite> graphite = Optional.empty();

        public boolean isJvmMetrics() {
            return this.jvmMetrics;
        }

        public Config jvmMetrics(boolean jvmMetrics) {
            this.jvmMetrics = jvmMetrics;
            return this;
        }

        public Map<String, String> getRequestMetricGroups() {
            return this.requestMetricGroups;
        }

        public Config requestMetricGroups(Map<String, String> requestMetricGroups) {
            this.requestMetricGroups = requestMetricGroups;
            return this;
        }

        public Optional<Jmx> getJmx() {
            return this.jmx;
        }

        public Config jmx() {
            return this.jmx((Action<? super Jmx>)Action.noop());
        }

        public Config jmx(Action<? super Jmx> configure) {
            try {
                configure.execute((Object)this.jmx.orElseGet(() -> {
                    this.jmx = Optional.of(new Jmx());
                    return this.jmx.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public Optional<Console> getConsole() {
            return this.console;
        }

        public Config console() {
            return this.console((Action<? super Console>)Action.noop());
        }

        public Config console(Action<? super Console> configure) {
            try {
                configure.execute((Object)this.console.orElseGet(() -> {
                    this.console = Optional.of(new Console());
                    return this.console.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public Optional<Slf4j> getSlf4j() {
            return this.slf4j;
        }

        public Config slf4j() {
            return this.slf4j((Action<? super Slf4j>)Action.noop());
        }

        public Config slf4j(Action<? super Slf4j> configure) {
            try {
                configure.execute((Object)this.slf4j.orElseGet(() -> {
                    this.slf4j = Optional.of(new Slf4j());
                    return this.slf4j.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public Optional<WebSocket> getWebSocket() {
            return this.webSocket;
        }

        public Config webSocket() {
            return this.webSocket((Action<? super WebSocket>)Action.noop());
        }

        public Config webSocket(Action<? super WebSocket> configure) {
            try {
                configure.execute((Object)this.webSocket.orElseGet(() -> {
                    this.webSocket = Optional.of(new WebSocket());
                    return this.webSocket.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public Optional<Csv> getCsv() {
            return this.csv;
        }

        public Config csv(Action<? super Csv> configure) {
            try {
                configure.execute((Object)this.csv.orElseGet(() -> {
                    this.csv = Optional.of(new Csv());
                    return this.csv.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public Optional<Graphite> getGraphite() {
            return this.graphite;
        }

        public Config graphite(Action<? super Graphite> configure) {
            try {
                configure.execute((Object)this.graphite.orElseGet(() -> {
                    this.graphite = Optional.of(new Graphite());
                    return this.graphite.get();
                }));
                return this;
            }
            catch (Exception e) {
                throw Exceptions.uncheck((Throwable)e);
            }
        }

        public static class Csv {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private File reportDirectory;
            private boolean enabled = true;
            private String includeFilter;
            private String excludeFilter;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Csv enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public String getIncludeFilter() {
                return this.includeFilter;
            }

            public Csv includeFilter(String includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public String getExcludeFilter() {
                return this.excludeFilter;
            }

            public Csv excludeFilter(String excludeFilter) {
                this.excludeFilter = excludeFilter;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Csv reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }

            public File getReportDirectory() {
                return this.reportDirectory;
            }

            public Csv reportDirectory(File reportDirectory) {
                this.reportDirectory = reportDirectory;
                return this;
            }
        }

        public static class WebSocket {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private String includeFilter;
            private String excludeFilter;

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public WebSocket reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }

            public String getIncludeFilter() {
                return this.includeFilter;
            }

            public WebSocket includeFilter(String includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public String getExcludeFilter() {
                return this.excludeFilter;
            }

            public WebSocket excludeFilter(String excludeFilter) {
                this.excludeFilter = excludeFilter;
                return this;
            }
        }

        public static class Slf4j {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private boolean enabled = true;
            private String includeFilter;
            private String excludeFilter;
            private Marker marker;
            private String prefix;
            private TimeUnit durationUnit;
            private TimeUnit rateUnit;
            private Slf4jReporter.LoggingLevel logLevel;
            private Logger logger;

            public Marker getMarker() {
                return this.marker;
            }

            public Slf4j marker(Marker marker) {
                this.marker = marker;
                return this;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public Slf4j prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public TimeUnit getDurationUnit() {
                return this.durationUnit;
            }

            public Slf4j durationUnit(TimeUnit durationUnit) {
                this.durationUnit = durationUnit;
                return this;
            }

            public TimeUnit getRateUnit() {
                return this.rateUnit;
            }

            public Slf4j rateUnit(TimeUnit rateUnit) {
                this.rateUnit = rateUnit;
                return this;
            }

            public Slf4jReporter.LoggingLevel getLogLevel() {
                return this.logLevel;
            }

            public Slf4j logLevel(Slf4jReporter.LoggingLevel logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            public Logger getLogger() {
                return this.logger;
            }

            public Slf4j logger(Logger logger) {
                this.logger = logger;
                return this;
            }

            public boolean isEnabled() {
                return this.enabled;
            }

            public Slf4j enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public String getIncludeFilter() {
                return this.includeFilter;
            }

            public Slf4j includeFilter(String includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public String getExcludeFilter() {
                return this.excludeFilter;
            }

            public Slf4j excludeFilter(String excludeFilter) {
                this.excludeFilter = excludeFilter;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Slf4j reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Console {
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private boolean enabled = true;
            private String includeFilter;
            private String excludeFilter;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Console enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public String getIncludeFilter() {
                return this.includeFilter;
            }

            public Console includeFilter(String includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public String getExcludeFilter() {
                return this.excludeFilter;
            }

            public Console excludeFilter(String excludeFilter) {
                this.excludeFilter = excludeFilter;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Console reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Jmx {
            private boolean enabled = true;
            private String includeFilter;
            private String excludeFilter;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Jmx enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public String getIncludeFilter() {
                return this.includeFilter;
            }

            public Jmx includeFilter(String includeFilter) {
                this.includeFilter = includeFilter;
                return this;
            }

            public String getExcludeFilter() {
                return this.excludeFilter;
            }

            public Jmx excludeFilter(String excludeFilter) {
                this.excludeFilter = excludeFilter;
                return this;
            }
        }
    }
}

