/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.codahale.metrics.NamedHealthCheck;
import ratpack.codahale.metrics.internal.ConsoleReporterProvider;
import ratpack.codahale.metrics.internal.CsvReporterProvider;
import ratpack.codahale.metrics.internal.GaugeTypeListener;
import ratpack.codahale.metrics.internal.HealthCheckResultRenderer;
import ratpack.codahale.metrics.internal.HealthCheckResultsRenderer;
import ratpack.codahale.metrics.internal.JmxReporterProvider;
import ratpack.codahale.metrics.internal.MeteredMethodInterceptor;
import ratpack.codahale.metrics.internal.MetricRegistryJsonMapper;
import ratpack.codahale.metrics.internal.MetricRegistryPeriodicPublisher;
import ratpack.codahale.metrics.internal.MetricsBroadcaster;
import ratpack.codahale.metrics.internal.RequestTimingHandler;
import ratpack.codahale.metrics.internal.TimedMethodInterceptor;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.guice.internal.GuiceUtil;
import ratpack.handling.Handler;
import ratpack.util.ExceptionUtils;

public class CodaHaleMetricsModule
extends ConfigurableModule<Config>
implements HandlerDecoratingModule {
    public static final String RATPACK_METRIC_REGISTRY = "ratpack-metrics";

    protected void configure() {
        SharedMetricRegistries.remove((String)RATPACK_METRIC_REGISTRY);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)RATPACK_METRIC_REGISTRY);
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Metered.class), new MethodInterceptor[]{this.injected(new MeteredMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Timed.class), new MethodInterceptor[]{this.injected(new TimedMethodInterceptor())});
        this.bindListener(Matchers.any(), this.injected(new GaugeTypeListener()));
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ConsoleReporter.class).toProvider(ConsoleReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(CsvReporter.class).toProvider(CsvReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryPeriodicPublisher.class).in(Scopes.SINGLETON);
        this.bind(MetricsBroadcaster.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryJsonMapper.class).in(Scopes.SINGLETON);
        this.bind(HealthCheckRegistry.class).in(Scopes.SINGLETON);
        this.bind(HealthCheckResultRenderer.class).in(Scopes.SINGLETON);
        this.bind(HealthCheckResultsRenderer.class).in(Scopes.SINGLETON);
    }

    private <T> T injected(T instance) {
        this.requestInjection(instance);
        return instance;
    }

    public Handler decorate(Injector injector, Handler handler) {
        Config config = (Config)injector.getInstance(Config.class);
        if (config.isHealthChecks()) {
            final HealthCheckRegistry registry = (HealthCheckRegistry)injector.getInstance(HealthCheckRegistry.class);
            GuiceUtil.eachOfType((Injector)injector, (TypeToken)TypeToken.of(NamedHealthCheck.class), (Action)new Action<NamedHealthCheck>(){

                public void execute(NamedHealthCheck healthCheck) throws Exception {
                    registry.register(healthCheck.getName(), (HealthCheck)healthCheck);
                }
            });
        }
        if (config.isEnabled()) {
            Config.Jmx jmx = config.getJmx();
            Config.Console console = config.getConsole();
            Config.Csv csv = config.getCsv();
            if (jmx.isEnabled()) {
                ((JmxReporter)injector.getInstance(JmxReporter.class)).start();
            }
            if (console.isEnabled()) {
                ((ConsoleReporter)injector.getInstance(ConsoleReporter.class)).start(console.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
            }
            if (csv.isEnabled()) {
                ((CsvReporter)injector.getInstance(CsvReporter.class)).start(csv.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
            }
            if (config.isJvmMetrics()) {
                MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
                metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
                metricRegistry.registerAll((MetricSet)new ThreadStatesGaugeSet());
                metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
            }
            return new RequestTimingHandler(handler);
        }
        return handler;
    }

    public static class Config {
        public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(30L);
        private boolean enabled;
        private boolean healthChecks;
        private boolean jvmMetrics;
        private Jmx jmx = new Jmx();
        private Console console = new Console();
        private WebSocket webSocket = new WebSocket();
        private Csv csv = new Csv();

        public boolean isEnabled() {
            return this.enabled;
        }

        public Config enable(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public boolean isHealthChecks() {
            return this.healthChecks;
        }

        public Config healthChecks(boolean healthChecks) {
            this.healthChecks = healthChecks;
            return this;
        }

        public boolean isJvmMetrics() {
            return this.jvmMetrics;
        }

        public Config jvmMetrics(boolean jvmMetrics) {
            this.jvmMetrics = jvmMetrics;
            return this;
        }

        public Jmx getJmx() {
            return this.jmx;
        }

        public Config jmx(Action<Jmx> configure) {
            try {
                configure.execute((Object)this.jmx);
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public Console getConsole() {
            return this.console;
        }

        public Config console(Action<Console> configure) {
            try {
                configure.execute((Object)this.console);
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public WebSocket getWebSocket() {
            return this.webSocket;
        }

        public Config webSocket(Action<WebSocket> configure) {
            try {
                configure.execute((Object)this.webSocket);
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public Csv getCsv() {
            return this.csv;
        }

        public Config csv(Action<Csv> configure) {
            try {
                configure.execute((Object)this.csv);
                return this;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }

        public static class Csv {
            private boolean enabled;
            private Duration reporterInterval = DEFAULT_INTERVAL;
            private File reportDirectory;

            public boolean isEnabled() {
                return this.enabled && this.reportDirectory != null;
            }

            public Csv enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Csv reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }

            public File getReportDirectory() {
                return this.reportDirectory;
            }

            public Csv reportDirectory(File reportDirectory) {
                this.reportDirectory = reportDirectory;
                return this;
            }
        }

        public static class WebSocket {
            private Duration reporterInterval = DEFAULT_INTERVAL;

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public WebSocket reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Console {
            private boolean enabled;
            private Duration reporterInterval = DEFAULT_INTERVAL;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Console enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Duration getReporterInterval() {
                return this.reporterInterval;
            }

            public Console reporterInterval(Duration reporterInterval) {
                this.reporterInterval = reporterInterval;
                return this;
            }
        }

        public static class Jmx {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public Jmx enable(boolean enabled) {
                this.enabled = enabled;
                return this;
            }
        }
    }
}

