/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import ratpack.codahale.metrics.internal.BlockingExecTimingInterceptor;
import ratpack.exec.ExecInterceptor;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;

public class RequestTimingHandler
implements Handler {
    private final Handler rest;

    public RequestTimingHandler(Handler rest) {
        this.rest = rest;
    }

    public void handle(Context context) throws Exception {
        MetricRegistry metricRegistry = (MetricRegistry)context.get(MetricRegistry.class);
        Request request = context.getRequest();
        BlockingExecTimingInterceptor blockingExecTimingInterceptor = new BlockingExecTimingInterceptor(metricRegistry, request);
        context.addInterceptor((ExecInterceptor)blockingExecTimingInterceptor, () -> {
            String tag = this.buildRequestTimerTag(request.getUri(), request.getMethod().getName());
            Timer.Context timer = metricRegistry.timer(tag).time();
            context.onClose(thing -> timer.stop());
            context.insert(new Handler[]{this.rest});
        });
    }

    private String buildRequestTimerTag(String requestUri, String requestMethod) {
        return (requestUri.equals("/") ? "[root" : requestUri.replaceFirst("/", "[").replace("/", "][")) + "]~" + requestMethod + "~Request";
    }
}

