/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.func.Function;

public class MetricRegistryJsonMapper
implements Function<MetricRegistry, ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricRegistryJsonMapper.class);
    private static final TimeUnit DEFAULT_RATE_UNIT = TimeUnit.SECONDS;
    private static final TimeUnit DEFAULT_DURATION_UNIT = TimeUnit.MILLISECONDS;
    private final JsonFactory factory = new JsonFactory();
    private final Clock clock = Clock.defaultClock();
    private final double durationFactor;
    private final double rateFactor;
    private final ByteBufAllocator byteBufAllocator;

    @Inject
    public MetricRegistryJsonMapper(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
        this.durationFactor = 1.0 / (double)DEFAULT_DURATION_UNIT.toNanos(1L);
        this.rateFactor = DEFAULT_RATE_UNIT.toSeconds(1L);
    }

    public ByteBuf apply(MetricRegistry metricRegistry) throws Exception {
        ByteBuf byteBuf = this.byteBufAllocator.ioBuffer();
        try {
            ByteBufOutputStream out = new ByteBufOutputStream(byteBuf);
            JsonGenerator json = this.factory.createGenerator((OutputStream)out);
            json.writeStartObject();
            json.writeNumberField("timestamp", this.clock.getTime());
            this.writeTimers(json, metricRegistry.getTimers());
            this.writeGauges(json, metricRegistry.getGauges());
            this.writeMeters(json, metricRegistry.getMeters());
            this.writeCounters(json, metricRegistry.getCounters());
            this.writeHistograms(json, metricRegistry.getHistograms());
            json.writeEndObject();
            json.flush();
            json.close();
            return byteBuf;
        }
        catch (Exception e) {
            byteBuf.release();
            throw e;
        }
    }

    private void writeHistograms(JsonGenerator json, SortedMap<String, Histogram> histograms) throws IOException {
        json.writeArrayFieldStart("histograms");
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            Histogram histogram = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", histogram.getCount());
            Snapshot snapshot = histogram.getSnapshot();
            json.writeNumberField("min", this.convertDuration(snapshot.getMin()));
            json.writeNumberField("max", this.convertDuration(snapshot.getMax()));
            json.writeNumberField("mean", this.convertDuration(snapshot.getMean()));
            json.writeNumberField("stdDev", this.convertDuration(snapshot.getStdDev()));
            json.writeNumberField("50thPercentile", this.convertDuration(snapshot.getMedian()));
            json.writeNumberField("75thPercentile", this.convertDuration(snapshot.get75thPercentile()));
            json.writeNumberField("95thPercentile", this.convertDuration(snapshot.get95thPercentile()));
            json.writeNumberField("98thPercentile", this.convertDuration(snapshot.get98thPercentile()));
            json.writeNumberField("99thPercentile", this.convertDuration(snapshot.get99thPercentile()));
            json.writeNumberField("999thPercentile", this.convertDuration(snapshot.get999thPercentile()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeCounters(JsonGenerator json, SortedMap<String, Counter> counters) throws IOException {
        json.writeArrayFieldStart("counters");
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            Counter counter = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", counter.getCount());
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeMeters(JsonGenerator json, SortedMap<String, Meter> meters) throws IOException {
        json.writeArrayFieldStart("meters");
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            Meter meter = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", meter.getCount());
            json.writeNumberField("meanRate", this.convertRate(meter.getMeanRate()));
            json.writeNumberField("oneMinuteRate", this.convertRate(meter.getOneMinuteRate()));
            json.writeNumberField("fiveMinuteRate", this.convertRate(meter.getFiveMinuteRate()));
            json.writeNumberField("fifteenMinuteRate", this.convertRate(meter.getFifteenMinuteRate()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeTimers(JsonGenerator json, SortedMap<String, Timer> timers) throws IOException {
        json.writeArrayFieldStart("timers");
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            Timer timer = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", timer.getCount());
            json.writeNumberField("meanRate", this.convertRate(timer.getMeanRate()));
            json.writeNumberField("oneMinuteRate", this.convertRate(timer.getOneMinuteRate()));
            json.writeNumberField("fiveMinuteRate", this.convertRate(timer.getFiveMinuteRate()));
            json.writeNumberField("fifteenMinuteRate", this.convertRate(timer.getFifteenMinuteRate()));
            Snapshot snapshot = timer.getSnapshot();
            json.writeNumberField("min", this.convertDuration(snapshot.getMin()));
            json.writeNumberField("max", this.convertDuration(snapshot.getMax()));
            json.writeNumberField("mean", this.convertDuration(snapshot.getMean()));
            json.writeNumberField("stdDev", this.convertDuration(snapshot.getStdDev()));
            json.writeNumberField("50thPercentile", this.convertDuration(snapshot.getMedian()));
            json.writeNumberField("75thPercentile", this.convertDuration(snapshot.get75thPercentile()));
            json.writeNumberField("95thPercentile", this.convertDuration(snapshot.get95thPercentile()));
            json.writeNumberField("98thPercentile", this.convertDuration(snapshot.get98thPercentile()));
            json.writeNumberField("99thPercentile", this.convertDuration(snapshot.get99thPercentile()));
            json.writeNumberField("999thPercentile", this.convertDuration(snapshot.get999thPercentile()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeGauges(JsonGenerator json, SortedMap<String, Gauge> gauges) throws IOException {
        json.writeArrayFieldStart("gauges");
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Gauge gauge = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            try {
                json.writeFieldName("value");
                json.writeObject(gauge.getValue());
            }
            catch (Exception e) {
                LOGGER.debug("Exception encountered while reporting [" + entry.getKey() + "]: " + e.getLocalizedMessage());
                json.writeNull();
            }
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private double convertDuration(double duration) {
        return duration * this.durationFactor;
    }

    private double convertRate(double rate) {
        return rate * this.rateFactor;
    }
}

