/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.collect.ImmutableSortedMap;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import ratpack.codahale.metrics.HealthCheckResults;
import ratpack.handling.Context;
import ratpack.handling.Handler;

public class HealthCheckHandler
implements Handler {
    public static final String DEFAULT_HEALTH_CHECK_NAME_TOKEN = "name";
    private final String healthCheckNameToken;

    public HealthCheckHandler() {
        this(DEFAULT_HEALTH_CHECK_NAME_TOKEN);
    }

    public HealthCheckHandler(String healthCheckNameToken) {
        this.healthCheckNameToken = healthCheckNameToken;
    }

    public void handle(Context context) throws Exception {
        HealthCheckRegistry registry = (HealthCheckRegistry)context.get(HealthCheckRegistry.class);
        String healthCheckName = (String)context.getPathTokens().get((Object)this.healthCheckNameToken);
        if (healthCheckName != null) {
            HealthCheck.Result result;
            try {
                result = registry.runHealthCheck(healthCheckName);
            }
            catch (NoSuchElementException e) {
                result = null;
            }
            if (result == null) {
                context.clientError(404);
            } else {
                context.render((Object)result);
            }
        } else {
            SortedMap healthCheckResults = registry.runHealthChecks();
            HealthCheckResults wrappedHealthCheckResults = new HealthCheckResults((ImmutableSortedMap<String, HealthCheck.Result>)ImmutableSortedMap.copyOfSorted((SortedMap)healthCheckResults));
            context.render((Object)wrappedHealthCheckResults);
        }
    }
}

