/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import ratpack.launch.LaunchConfig;

public class CsvReporterProvider
implements Provider<CsvReporter> {
    public static final String CSV_REPORT_DIRECTORY = "ratpack.codahale.metrics.internal.CsvReporterProvider.csvReportDirectory";
    private final MetricRegistry metricRegistry;
    private final File csvReportDirectory;
    private final LaunchConfig launchConfig;

    @Inject
    public CsvReporterProvider(MetricRegistry metricRegistry, @Named(value="ratpack.codahale.metrics.internal.CsvReporterProvider.csvReportDirectory") File csvReportDirectory, LaunchConfig launchConfig) {
        this.metricRegistry = metricRegistry;
        this.csvReportDirectory = csvReportDirectory;
        this.launchConfig = launchConfig;
    }

    public CsvReporter get() {
        CsvReporter reporter = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry).build(this.csvReportDirectory);
        String interval = this.launchConfig.getOther("metrics.scheduledreporter.interval", "30");
        reporter.start(Long.parseLong(interval), TimeUnit.SECONDS);
        return reporter;
    }
}

