/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.RequestOutcome;
import ratpack.http.Request;
import ratpack.util.Action;

public class RequestTimingHandler
implements Handler {
    private final Handler rest;

    public RequestTimingHandler(Handler rest) {
        this.rest = rest;
    }

    public void handle(Context context) throws Exception {
        Request request = context.getRequest();
        String tag = this.buildRequestTimerTag(request.getUri(), request.getMethod().getName());
        MetricRegistry metricRegistry = (MetricRegistry)context.get(MetricRegistry.class);
        final Timer.Context timer = metricRegistry.timer(tag).time();
        context.onClose((Action)new Action<RequestOutcome>(){

            public void execute(RequestOutcome thing) throws Exception {
                timer.stop();
            }
        });
        context.insert(new Handler[]{this.rest});
    }

    private String buildRequestTimerTag(String requestUri, String requestMethod) {
        return (requestUri.equals("/") ? "[root" : requestUri.replaceFirst("/", "[").replace("/", "][")) + "]~" + requestMethod + "~Request";
    }
}

