/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Metered;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MeteredMethodInterceptor
implements MethodInterceptor {
    @Inject
    MetricRegistry metricRegistry;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String meterTag = this.buildMeterTag(invocation.getMethod().getAnnotation(Metered.class), invocation.getMethod());
        this.metricRegistry.meter(meterTag).mark();
        return invocation.proceed();
    }

    private String buildMeterTag(Metered annotation, Method method) {
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName()});
        }
        if (annotation.absolute()) {
            return annotation.name();
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{annotation.name()});
    }
}

