/*
 * Decompiled with CFR 0.152.
 */
package io.qubite.tomoko.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.qubite.tomoko.handler.value.converter.ValueTreeParser;
import io.qubite.tomoko.jackson.JacksonTree;
import io.qubite.tomoko.path.converter.ConverterException;
import io.qubite.tomoko.type.CollectionType;
import io.qubite.tomoko.type.GenericType;
import io.qubite.tomoko.type.MapType;
import io.qubite.tomoko.type.SimpleType;
import io.qubite.tomoko.type.ValueType;
import java.io.IOException;

public class JacksonTreeParser
implements ValueTreeParser<JacksonTree> {
    private final ObjectMapper mapper;

    JacksonTreeParser(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static JacksonTreeParser instance() {
        return JacksonTreeParser.instance(new ObjectMapper());
    }

    public static JacksonTreeParser instance(ObjectMapper mapper) {
        return new JacksonTreeParser(mapper);
    }

    public <T> T getAs(JacksonTree node, ValueType<T> valueType) {
        try {
            return this.parse(node.getValue(), valueType);
        }
        catch (JsonMappingException e) {
            throw new ConverterException("Could not parse the provided value as " + valueType, (Throwable)e);
        }
        catch (IOException e) {
            throw new ConverterException((Throwable)e);
        }
    }

    public Class<JacksonTree> supportedType() {
        return JacksonTree.class;
    }

    private <T> T parse(JsonNode node, ValueType<T> valueType) throws IOException {
        JavaType javaType = null;
        if (valueType instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)valueType;
            javaType = TypeFactory.defaultInstance().uncheckedSimpleType(simpleType.getBaseClass());
        } else if (valueType instanceof GenericType) {
            GenericType genericType = (GenericType)valueType;
            javaType = TypeFactory.defaultInstance().constructParametricType(genericType.getBaseClass(), genericType.getParameterTypes());
        } else if (valueType instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)valueType;
            javaType = TypeFactory.defaultInstance().constructCollectionType(collectionType.getBaseClass(), collectionType.getElementClass());
        } else if (valueType instanceof MapType) {
            MapType mapType = (MapType)valueType;
            javaType = TypeFactory.defaultInstance().constructMapType(mapType.getBaseClass(), mapType.getKeyClass(), mapType.getValueClass());
        } else {
            throw new IllegalArgumentException("Unexpected class instance encountered: " + valueType.getClass());
        }
        return (T)this.parse(node, javaType);
    }

    private Object parse(JsonNode node, JavaType javaType) throws IOException {
        return this.mapper.readValue(node.traverse(), javaType);
    }
}

