/*
 * Decompiled with CFR 0.152.
 */
package io.qubite.tomoko.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import io.qubite.tomoko.patch.ValueTree;
import io.qubite.tomoko.util.Preconditions;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;

class JacksonTree
implements ValueTree {
    private final JsonNode node;

    JacksonTree(JsonNode node) {
        this.node = node;
    }

    static JacksonTree of(JsonNode node) {
        Preconditions.checkNotNull((Object)node);
        return new JacksonTree(node);
    }

    public Iterator<Map.Entry<String, ValueTree>> getFieldIterator() {
        return new JacksonIterator(this.node.fields());
    }

    public JsonNode getValue() {
        return this.node;
    }

    public String toString() {
        return this.node.toString();
    }

    private class JacksonIterator
    implements Iterator<Map.Entry<String, ValueTree>> {
        private final Iterator<Map.Entry<String, JsonNode>> originalIterator;

        private JacksonIterator(Iterator<Map.Entry<String, JsonNode>> originalIterator) {
            this.originalIterator = originalIterator;
        }

        @Override
        public boolean hasNext() {
            return this.originalIterator.hasNext();
        }

        @Override
        public Map.Entry<String, ValueTree> next() {
            Map.Entry<String, JsonNode> next = this.originalIterator.next();
            return new AbstractMap.SimpleEntry<String, ValueTree>(next.getKey(), JacksonTree.of(next.getValue()));
        }
    }
}

