/*
 * Decompiled with CFR 0.152.
 */
package io.qubite.tomoko.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.qubite.tomoko.Tomoko;
import io.qubite.tomoko.TomokoConfiguration;
import io.qubite.tomoko.TomokoConfigurationBuilder;
import io.qubite.tomoko.handler.value.converter.ValueTreeParser;
import io.qubite.tomoko.jackson.JacksonTreeParser;
import io.qubite.tomoko.jackson.PatchParser;
import io.qubite.tomoko.patcher.Patcher;
import io.qubite.tomoko.specification.PatcherTreeSpecification;
import io.qubite.tomoko.specification.descriptor.SpecificationDescriptor;
import io.qubite.tomoko.specification.dsl.HandlerConfigurationDSL;

public class JacksonTomoko {
    private final Tomoko tomoko;
    private final ObjectMapper mapper;

    JacksonTomoko(Tomoko tomoko, ObjectMapper mapper) {
        this.tomoko = tomoko;
        this.mapper = mapper;
    }

    public static JacksonTomoko instance() {
        return JacksonTomoko.instance(new ObjectMapper());
    }

    public static JacksonTomoko instance(ObjectMapper mapper) {
        return JacksonTomoko.instance(TomokoConfigurationBuilder.base(), mapper);
    }

    public static JacksonTomoko instance(TomokoConfigurationBuilder configurationBuilder) {
        return JacksonTomoko.instance(configurationBuilder, new ObjectMapper());
    }

    public static JacksonTomoko instance(TomokoConfigurationBuilder configurationBuilder, ObjectMapper mapper) {
        configurationBuilder.clearValueTreeParsers();
        configurationBuilder.registerValueTreeParser((ValueTreeParser)new JacksonTreeParser(mapper));
        Tomoko tomoko = Tomoko.instance((TomokoConfiguration)configurationBuilder.build());
        return new JacksonTomoko(tomoko, mapper);
    }

    public HandlerConfigurationDSL specificationDsl() {
        return this.tomoko.specificationDsl();
    }

    public PatcherTreeSpecification scanHandlerTree(Object specification) {
        return this.tomoko.scanHandlerTree(specification);
    }

    public Patcher patcher(PatcherTreeSpecification specification) {
        return this.tomoko.patcher(specification);
    }

    public Patcher scanPatcher(Object specification) {
        return this.tomoko.scanPatcher(specification);
    }

    public <T> SpecificationDescriptor<T> descriptorFor(Class<T> specificationClass) {
        return this.tomoko.descriptorFor(specificationClass);
    }

    public PatchParser patchParser() {
        return PatchParser.instance(this.mapper);
    }
}

