/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.webauthn;

import com.webauthn4j.util.Base64UrlUtil;
import io.quarkus.security.webauthn.WebAuthnCredentialRecord;
import io.quarkus.security.webauthn.WebAuthnUserProvider;
import io.smallrye.mutiny.Uni;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WebAuthnTestUserProvider
implements WebAuthnUserProvider {
    private List<WebAuthnCredentialRecord> auths = new ArrayList<WebAuthnCredentialRecord>();

    public Uni<List<WebAuthnCredentialRecord>> findByUsername(String userId) {
        ArrayList<WebAuthnCredentialRecord> ret = new ArrayList<WebAuthnCredentialRecord>();
        for (WebAuthnCredentialRecord authenticator : this.auths) {
            if (!authenticator.getUsername().equals(userId)) continue;
            ret.add(authenticator);
        }
        return Uni.createFrom().item(ret);
    }

    public Uni<WebAuthnCredentialRecord> findByCredentialId(String credId) {
        byte[] bytes = Base64UrlUtil.decode((String)credId);
        for (WebAuthnCredentialRecord authenticator : this.auths) {
            if (!Arrays.equals(authenticator.getAttestedCredentialData().getCredentialId(), bytes)) continue;
            return Uni.createFrom().item((Object)authenticator);
        }
        return Uni.createFrom().failure((Throwable)new RuntimeException("Credentials not found for credential ID " + credId));
    }

    public Uni<Void> update(String credentialId, long counter) {
        this.reallyUpdate(credentialId, counter);
        return Uni.createFrom().voidItem();
    }

    public Uni<Void> store(WebAuthnCredentialRecord credentialRecord) {
        this.reallyStore(credentialRecord);
        return Uni.createFrom().voidItem();
    }

    public Set<String> getRoles(String username) {
        return Collections.singleton("admin");
    }

    public void clear() {
        this.auths.clear();
    }

    public void reallyUpdate(String credentialId, long counter) {
        byte[] bytes = Base64UrlUtil.decode((String)credentialId);
        for (WebAuthnCredentialRecord authenticator : this.auths) {
            if (!Arrays.equals(authenticator.getAttestedCredentialData().getCredentialId(), bytes)) continue;
            authenticator.setCounter(counter);
            break;
        }
    }

    public void reallyStore(WebAuthnCredentialRecord credentialRecord) {
        this.auths.add(credentialRecord);
    }
}

