/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kind.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesClientCapabilityBuildItem;
import io.quarkus.kubernetes.deployment.AddPortToKubernetesConfig;
import io.quarkus.kubernetes.deployment.DevClusterHelper;
import io.quarkus.kubernetes.deployment.InitTaskConfig;
import io.quarkus.kubernetes.deployment.InitTaskProcessor;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesClusterRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEffectiveServiceAccountBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesInitContainerBuildItem;
import io.quarkus.kubernetes.spi.KubernetesJobBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesNamespaceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesProbePortNameBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.kubernetes.spi.KubernetesServiceAccountBuildItem;
import io.smallrye.common.process.AbnormalExitException;
import io.smallrye.common.process.ProcessBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KindProcessor {
    private static final int KIND_PRIORITY = 30;

    @BuildStep
    public void checkKind(ApplicationInfoBuildItem applicationInfo, KubernetesConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kind", "Deployment", "apps", "v1", 30, true, config.deployStrategy()));
        String name = ResourceNameUtil.getResourceName((PlatformConfiguration)config, (ApplicationInfoBuildItem)applicationInfo);
        resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", name));
    }

    @BuildStep
    public void createAnnotations(KubernetesConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.annotations().forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "kind")));
    }

    @BuildStep
    public void createLabels(KubernetesConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.labels().forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "kind"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
        labels.produce((BuildItem)new KubernetesLabelBuildItem("app.kubernetes.io/managed-by", "quarkus", "kind"));
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(KubernetesConfig config, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, (PlatformConfiguration)config).values().forEach(value -> result.add(new ConfiguratorBuildItem((Object)new AddPortToKubernetesConfig(value))));
        return result;
    }

    @BuildStep
    public KubernetesEffectiveServiceAccountBuildItem computeEffectiveServiceAccounts(ApplicationInfoBuildItem applicationInfo, KubernetesConfig config, List<KubernetesServiceAccountBuildItem> serviceAccountsFromExtensions, BuildProducer<DecoratorBuildItem> decorators) {
        String name = ResourceNameUtil.getResourceName((PlatformConfiguration)config, (ApplicationInfoBuildItem)applicationInfo);
        return KubernetesCommonHelper.computeEffectiveServiceAccount((String)name, (String)"kind", (PlatformConfiguration)config, serviceAccountsFromExtensions, decorators);
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KubernetesConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, Optional<KubernetesClientCapabilityBuildItem> kubernetesClientConfiguration, List<KubernetesNamespaceBuildItem> namespaces, List<KubernetesInitContainerBuildItem> initContainers, List<KubernetesJobBuildItem> jobs, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesProbePortNameBuildItem> portName, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, Optional<KubernetesHealthStartupPathBuildItem> startupPath, List<KubernetesRoleBuildItem> roles, List<KubernetesClusterRoleBuildItem> clusterRoles, List<KubernetesEffectiveServiceAccountBuildItem> serviceAccounts, List<KubernetesRoleBindingBuildItem> roleBindings, List<KubernetesClusterRoleBindingBuildItem> clusterRoleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot) {
        return DevClusterHelper.createDecorators((String)"kind", (String)"kubernetes", (ApplicationInfoBuildItem)applicationInfo, (OutputTargetBuildItem)outputTarget, (KubernetesConfig)config, (PackageConfig)packageConfig, metricsConfiguration, kubernetesClientConfiguration, namespaces, initContainers, jobs, annotations, labels, envs, baseImage, image, command, ports, portName, livenessPath, readinessPath, startupPath, roles, clusterRoles, serviceAccounts, roleBindings, clusterRoleBindings, customProjectRoot);
    }

    @BuildStep
    public void postBuild(ContainerImageInfoBuildItem image, List<ContainerImageBuilderBuildItem> builders, BuildProducer<ArtifactResultBuildItem> artifactResults) {
        try {
            ProcessBuilder.exec((String)"kind", (String[])new String[]{"load", "docker-image", image.getImage()});
        }
        catch (AbnormalExitException abnormalExitException) {
            // empty catch block
        }
    }

    @BuildStep
    void externalizeInitTasks(ApplicationInfoBuildItem applicationInfo, KubernetesConfig config, ContainerImageInfoBuildItem image, List<InitTaskBuildItem> initTasks, BuildProducer<KubernetesJobBuildItem> jobs, BuildProducer<KubernetesInitContainerBuildItem> initContainers, BuildProducer<KubernetesEnvBuildItem> env, BuildProducer<KubernetesRoleBuildItem> roles, BuildProducer<KubernetesRoleBindingBuildItem> roleBindings, BuildProducer<KubernetesServiceAccountBuildItem> serviceAccount, BuildProducer<DecoratorBuildItem> decorators) {
        String name = ResourceNameUtil.getResourceName((PlatformConfiguration)config, (ApplicationInfoBuildItem)applicationInfo);
        if (config.externalizeInit()) {
            InitTaskProcessor.process((String)"kind", (String)name, (ContainerImageInfoBuildItem)image, initTasks, (InitTaskConfig)config.initTaskDefaults(), (Map)config.initTasks(), jobs, initContainers, env, roles, roleBindings, serviceAccount, decorators);
        }
    }
}

