/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Plugin;

public class PluginListItem {
    private final boolean installed;
    private final Plugin plugin;

    public PluginListItem(boolean installed, Plugin plugin) {
        this.installed = installed;
        this.plugin = plugin;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String getSymbol() {
        return this.installed ? "*" : " ";
    }

    public String getName() {
        return this.plugin.getName();
    }

    public String getType() {
        return this.plugin.getType().name();
    }

    public String getScope() {
        return this.plugin.isInUserCatalog() ? "user" : "project";
    }

    public String getLocation() {
        return this.plugin.getLocation().orElse("");
    }

    public String getDescription() {
        return this.plugin.getDescription().orElse("");
    }

    public String getCommand() {
        switch (this.plugin.getType()) {
            case jar: 
            case maven: {
                return "jbang " + this.plugin.getLocation().orElse("<unknown>");
            }
            case jbang: {
                return "jbang " + this.plugin.getLocation().orElse(this.plugin.getName());
            }
            case executable: {
                return this.plugin.getLocation().orElse("<unknown>");
            }
        }
        return "";
    }

    public String[] getFields() {
        return this.getFields(false);
    }

    public String[] getFields(boolean withCommand) {
        String[] stringArray;
        if (withCommand) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = this.getSymbol();
            stringArray2[1] = this.getName();
            stringArray2[2] = this.getType();
            stringArray2[3] = this.getScope();
            stringArray2[4] = this.getLocation();
            stringArray2[5] = this.getDescription();
            stringArray = stringArray2;
            stringArray2[6] = this.getCommand();
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = this.getSymbol();
            stringArray3[1] = this.getName();
            stringArray3[2] = this.getType();
            stringArray3[3] = this.getScope();
            stringArray3[4] = this.getLocation();
            stringArray = stringArray3;
            stringArray3[5] = this.getDescription();
        }
        return stringArray;
    }
}

