/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.plugin.JBangCommand;
import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCommand;
import io.quarkus.cli.plugin.PluginUtil;
import io.quarkus.cli.plugin.ShellCommand;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.runtime.util.StringUtil;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import picocli.CommandLine;

public class PluginCommandFactory {
    private final OutputOptionMixin output;

    protected PluginCommandFactory() {
        this(null);
    }

    public PluginCommandFactory(OutputOptionMixin output) {
        this.output = output;
    }

    private Optional<PluginCommand> createPluginCommand(Plugin plugin) {
        switch (plugin.getType()) {
            case maven: {
                return plugin.getLocation().flatMap(PluginUtil::checkGACTV).map(g -> new JBangCommand(PluginCommandFactory.toGAVC(g), this.output));
            }
            case java: 
            case jar: 
            case jbang: {
                return plugin.getLocation().map(l -> new JBangCommand((String)l, this.output));
            }
            case executable: {
                return plugin.getLocation().map(l -> new ShellCommand(plugin.getName(), Paths.get(l, new String[0]), this.output));
            }
            case extension: {
                if (PluginUtil.checkGACTV((Optional)plugin.getLocation()).isPresent()) {
                    return plugin.getLocation().flatMap(PluginUtil::checkGACTV).map(g -> new JBangCommand(PluginCommandFactory.toGAVC(g), this.output));
                }
                if (!plugin.getLocation().filter(l -> l.endsWith(".jar")).isPresent()) break;
                return plugin.getLocation().map(l -> new JBangCommand((String)l, this.output));
            }
        }
        throw new IllegalStateException("Unknown plugin type!");
    }

    public Optional<CommandLine.Model.CommandSpec> createCommand(Plugin plugin) {
        return this.createPluginCommand(plugin).map(this.createCommandSpec(plugin.getDescription().orElse("")));
    }

    public Function<PluginCommand, CommandLine.Model.CommandSpec> createCommandSpec(String description) {
        return command -> {
            CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.wrapWithoutInspection((Object)command);
            if (!StringUtil.isNullOrEmpty((String)description)) {
                spec.usageMessage().description(new String[]{description});
            }
            spec.parser().unmatchedArgumentsAllowed(true);
            spec.parser().unmatchedOptionsArePositionalParams(true);
            spec.add((CommandLine.Model.ArgSpec)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)((CommandLine.Model.PositionalParamSpec.Builder)CommandLine.Model.PositionalParamSpec.builder().type(String[].class)).arity("0..*")).description(new String[]{"Positional arguments"})).setter(new CommandLine.Model.ISetter(){
                final /* synthetic */ PluginCommand val$command;
                {
                    this.val$command = pluginCommand;
                }

                public <T> T set(T value) throws Exception {
                    if (value == null) {
                        return value;
                    }
                    if (value instanceof String[]) {
                        String[] array = (String[])value;
                        this.val$command.useArguments(Arrays.asList(array));
                    }
                    return value;
                }
            })).build());
            return spec;
        };
    }

    public void populateCommands(CommandLine cmd, Map<String, Plugin> plugins) {
        plugins.entrySet().stream().map(Map.Entry::getValue).forEach(plugin -> {
            CommandLine current = cmd;
            Object name = cmd.getCommandName() + "-" + plugin.getName();
            while (current != null && current.getCommandName() != null && ((String)name).startsWith(current.getCommandName() + "-")) {
                String remaining = ((String)name).substring(current.getCommandName().length() + 1);
                name = remaining;
                List subcommandKeys = current.getSubcommands().keySet().stream().filter(k -> remaining.startsWith((String)k)).collect(Collectors.toList());
                Optional<String> matchedKey = subcommandKeys.stream().sorted(Comparator.comparingInt(String::length)).findFirst();
                if (!matchedKey.isPresent()) break;
                current = (CommandLine)current.getSubcommands().get(matchedKey.get());
            }
            name = ((String)name).contains("@") ? ((String)name).split("@")[0] : name;
            String commandName = name;
            CommandLine commandParent = current;
            this.createCommand((Plugin)plugin).ifPresent(command -> {
                if (!commandParent.getSubcommands().containsKey(commandName)) {
                    commandParent.addSubcommand(commandName, command);
                }
            });
        });
    }

    private static String toGAVC(GACTV gactv) {
        return gactv.getGroupId() + ":" + gactv.getArtifactId() + ":" + gactv.getVersion() + (String)(StringUtil.isNullOrEmpty((String)gactv.getClassifier()) ? "" : ":" + gactv.getClassifier());
    }
}

