/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.avro.deployment.AvroCodeGenProviderBase;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenProvider;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;

public class AvroIDLCodeGenProvider
extends AvroCodeGenProviderBase
implements CodeGenProvider {
    public String providerId() {
        return "avdl";
    }

    public String[] inputExtensions() {
        return new String[]{"avdl"};
    }

    @Override
    void init() {
    }

    @Override
    void compileSingleFile(Path filePath, Path outputDir, AvroCodeGenProviderBase.AvroOptions options) throws CodeGenException {
        try (Idl parser = new Idl(filePath.toFile());){
            Protocol idlProtocol = parser.CompilationUnit();
            String json = idlProtocol.toString(false);
            Protocol protocol = Protocol.parse((String)json);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.setTemplateDir("/org/apache/avro/compiler/specific/templates/java/classic/");
            compiler.setStringType(options.stringType);
            compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
            compiler.setCreateOptionalGetters(options.createOptionalGetters);
            compiler.setGettersReturnOptional(options.gettersReturnOptional);
            compiler.setOptionalGettersForNullableFieldsOnly(options.optionalGettersForNullableFieldsOnly);
            compiler.setCreateSetters(options.createSetters);
            compiler.setEnableDecimalLogicalType(options.enableDecimalLogicalType);
            compiler.setOutputCharacterEncoding("UTF-8");
            compiler.compileToDestination(filePath.toFile(), outputDir.toFile());
        }
        catch (IOException | ParseException e) {
            throw new CodeGenException("Failed to compile avro IDL file: " + filePath.toString() + " to Java", e);
        }
    }
}

