/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash.devservices;

import io.quarkiverse.unleash.UnleashBuildTimeConfig;
import io.quarkiverse.unleash.devservices.ContainerShutdownCloseable;
import io.quarkiverse.unleash.devservices.UnleashDbDevServicesProviderBuildItem;
import io.quarkiverse.unleash.devservices.UnleashDevServicesConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class UnleashDbDevServiceProcessor {
    private static final Logger log = Logger.getLogger(UnleashDbDevServiceProcessor.class);
    static volatile UnleashDbRunningDevService devService;
    static volatile UnleashDbDevServiceCfg cfg;
    static volatile boolean first;
    public static final String DB_FEATURE_NAME = "unleash-db";
    private static final String DB_ALIAS = "unleash-db";
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-unleash-db";
    public static final int DEFAULT_UNLEASH_PORT = 5432;
    private static final ContainerLocator unleashContainerLocator;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public DevServicesResultBuildItem startUnleashDbContainers(LaunchModeBuildItem launchMode, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, UnleashBuildTimeConfig buildTimeConfig, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, BuildProducer<UnleashDbDevServicesProviderBuildItem> startResultProducer, CuratedApplicationShutdownBuildItem closeBuildItem, DockerStatusBuildItem dockerStatusBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig) {
        UnleashDbDevServiceCfg configuration = this.getConfiguration(buildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfg);
            if (!shouldShutdownTheBroker) {
                return devService.toBuildItem();
            }
            this.stopContainer();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Unleash Database Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startContainer(dockerStatusBuildItem, configuration, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.stopContainer();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.infof("The unleash database is ready to accept connections. Config: %s:%S/%s", (Object)UnleashDbDevServiceProcessor.devService.dbHost, (Object)UnleashDbDevServiceProcessor.devService.dbPort, (Object)UnleashDbDevServiceProcessor.devService.dbName);
            startResultProducer.produce((BuildItem)new UnleashDbDevServicesProviderBuildItem(UnleashDbDevServiceProcessor.devService.dbHost, UnleashDbDevServiceProcessor.devService.dbPort, UnleashDbDevServiceProcessor.devService.dbName, UnleashDbDevServiceProcessor.devService.dbUsername, UnleashDbDevServiceProcessor.devService.dbPassword));
        }
        return devService.toBuildItem();
    }

    private UnleashDbRunningDevService startContainer(DockerStatusBuildItem dockerStatusBuildItem, UnleashDbDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting dev services for Zeebe as it has been disabled in the config");
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)"Docker isn't working, please configure the unleash URL property (quarkus.unleash.url).");
            return null;
        }
        Optional maybeContainerAddress = unleashContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<UnleashDbRunningDevService> defaultUnleashSupplier = () -> {
            UnleashPostgreSQLContainer container = new UnleashPostgreSQLContainer(config.imageName, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT ? config.serviceName : null, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((UnleashPostgreSQLContainer)container).withStartupTimeout(arg_0));
            if (config.reuse) {
                container.withReuse(true);
            }
            container.start();
            return new UnleashDbRunningDevService("unleash-db", container.getContainerId(), new ContainerShutdownCloseable((GenericContainer<?>)container, "unleash-db"), container.getUnleashDbHost(), container.getUnleashDbPort(), container.getDatabaseName(), container.getUsername(), container.getPassword());
        };
        return maybeContainerAddress.map(containerAddress -> new UnleashDbRunningDevService("unleash-db", containerAddress.getId(), null)).orElseGet(defaultUnleashSupplier);
    }

    private UnleashDbDevServiceCfg getConfiguration(UnleashBuildTimeConfig cfg) {
        UnleashDevServicesConfig devServicesConfig = cfg.devService;
        return new UnleashDbDevServiceCfg(devServicesConfig);
    }

    private void stopContainer() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Zeebe broker", e);
            }
            finally {
                devService = null;
            }
        }
    }

    static {
        first = true;
        unleashContainerLocator = new ContainerLocator(DEV_SERVICE_LABEL, 5432);
    }

    private static final class UnleashDbDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final boolean shared;
        private final String serviceName;
        private final boolean reuse;

        public UnleashDbDevServiceCfg(UnleashDevServicesConfig config) {
            this.devServicesEnabled = config.enabled;
            UnleashDevServicesConfig.UnleashDatabaseConfig tmp = config.db;
            this.imageName = tmp.imageName;
            this.serviceName = tmp.serviceName;
            this.shared = config.shared;
            this.reuse = config.reuse;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnleashDbDevServiceCfg that = (UnleashDbDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName);
        }
    }

    public static class UnleashDbRunningDevService
    extends DevServicesResultBuildItem.RunningDevService {
        public String dbHost;
        public String dbUsername;
        public String dbPassword;
        public String dbName;
        public int dbPort;

        public UnleashDbRunningDevService(String name, String containerId, Closeable closeable) {
            super(name, containerId, closeable, Map.of());
        }

        public UnleashDbRunningDevService(String name, String containerId, Closeable closeable, String dbHost, int dbPort, String dbName, String dbUsername, String dbPassword) {
            super(name, containerId, closeable, Map.of());
            this.dbHost = dbHost;
            this.dbPort = dbPort;
            this.dbName = dbName;
            this.dbUsername = dbUsername;
            this.dbPassword = dbPassword;
        }
    }

    private static class UnleashPostgreSQLContainer
    extends PostgreSQLContainer<UnleashPostgreSQLContainer> {
        private final boolean useSharedNetwork;
        private String hostName = null;

        public UnleashPostgreSQLContainer(String imageName, String serviceName, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName).asCompatibleSubstituteFor(DockerImageName.parse((String)"postgres")));
            log.debugf("Unleash database docker image %s", (Object)imageName);
            this.useSharedNetwork = useSharedNetwork;
            if (serviceName != null) {
                this.withLabel(UnleashDbDevServiceProcessor.DEV_SERVICE_LABEL, serviceName);
            }
            this.addExposedPort(POSTGRESQL_PORT);
            this.hostName = "unleash-db";
            this.withNetworkAliases(new String[]{"unleash-db"});
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"unleash-db");
            } else {
                this.withNetwork(Network.SHARED);
            }
        }

        public String getUnleashDbHost() {
            return this.hostName;
        }

        public Integer getUnleashDbPort() {
            return POSTGRESQL_PORT;
        }
    }
}

