/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash;

import io.getunleash.ActivationStrategy;
import io.getunleash.Constraint;
import io.getunleash.DefaultUnleash;
import io.getunleash.Operator;
import io.getunleash.Unleash;
import io.getunleash.Variant;
import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.strategy.GradualRolloutRandomStrategy;
import io.getunleash.variant.Payload;
import io.getunleash.variant.VariantDefinition;
import io.getunleash.variant.VariantOverride;
import io.quarkiverse.unleash.FeatureToggle;
import io.quarkiverse.unleash.FeatureVariant;
import io.quarkiverse.unleash.UnleashJsonMapper;
import io.quarkiverse.unleash.runtime.AbstractVariantProducer;
import io.quarkiverse.unleash.runtime.FeatureToggleProducer;
import io.quarkiverse.unleash.runtime.ToggleVariantProducer;
import io.quarkiverse.unleash.runtime.ToggleVariantStringProducer;
import io.quarkiverse.unleash.runtime.UnleashRecorder;
import io.quarkiverse.unleash.runtime.UnleashResourceProducer;
import io.quarkiverse.unleash.runtime.UnleashRuntimeTimeConfig;
import io.quarkiverse.unleash.runtime.UnleashService;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.util.HashUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class UnleashProcessor {
    public static final String FEATURE_NAME = "unleash";
    public static final DotName DN_VARIANT = DotName.createSimple(Variant.class);
    public static final DotName DN_STRING = DotName.createSimple(String.class);
    public static final Set<DotName> IGNORE = Set.of(DN_VARIANT, DN_STRING);
    public static final DotName DN_FEATURE_VARIANT = DotName.createSimple(FeatureVariant.class);

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureRuntimeProperties(UnleashRecorder recorder, UnleashRuntimeTimeConfig runtimeConfig, ApplicationConfig appConfig, LaunchModeBuildItem launchMode) {
        recorder.initializeProducers(runtimeConfig, appConfig, launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void nativeImageConfiguration(BuildProducer<ReflectiveClassBuildItem> reflective) {
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{ClientRegistration.class.getName(), ClientMetrics.class.getName(), ActivationStrategy.class.getName(), Constraint.class.getName(), VariantDefinition.class.getName(), VariantOverride.class.getName(), Variant.class.getName(), Payload.class.getName(), Operator.class.getName(), io.getunleash.FeatureToggle.class.getName(), ToggleCollection.class.getName()}));
    }

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<ExtensionSslNativeSupportBuildItem> ssl) {
        ssl.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE_NAME));
        featureProducer.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
    }

    @BuildStep
    NativeImageConfigBuildItem buildNativeImage() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeInitializedClass(GradualRolloutRandomStrategy.class.getName());
        builder.addRuntimeInitializedClass(DefaultUnleash.class.getName());
        return builder.build();
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{UnleashService.class, FeatureToggle.class, FeatureToggleProducer.class, UnleashResourceProducer.class, ToggleVariantProducer.class, ToggleVariantStringProducer.class}).build();
    }

    @BuildStep
    void generateProducer(CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        IndexView index = combinedIndex.getIndex();
        Collection ais = index.getAnnotations(DN_FEATURE_VARIANT);
        HashSet<DotName> names = new HashSet<DotName>();
        for (AnnotationInstance ano : ais) {
            FieldInfo field = ano.target().asField();
            Type type = field.type();
            ParameterizedType pt = type.asParameterizedType();
            Type vt = (Type)pt.arguments().get(0);
            if (IGNORE.contains(vt.name())) continue;
            names.add(vt.name());
        }
        if (!names.isEmpty()) {
            GeneratedBeanGizmoAdaptor beansClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
            UnleashProcessor.generateProducerClass((ClassOutput)beansClassOutput, names);
        }
    }

    static void generateProducerClass(ClassOutput classOutput, Set<DotName> names) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className("io.quarkiverse.unleash.runtime.ToggleVariantObjectProducer").superClass(AbstractVariantProducer.class.getName()).build();){
            classCreator.addAnnotation(Singleton.class);
            FieldCreator unleash = (FieldCreator)classCreator.getFieldCreator(FEATURE_NAME, Unleash.class.getName()).setModifiers(1);
            unleash.addAnnotation(Inject.class);
            FieldCreator mapper = (FieldCreator)classCreator.getFieldCreator("unleashJsonMapper", UnleashJsonMapper.class.getName()).setModifiers(1);
            mapper.addAnnotation(Inject.class);
            for (DotName name : names) {
                String hash = "_" + HashUtil.sha1((String)name.toString());
                MethodCreator methodCreator = classCreator.getMethodCreator("produce" + name.withoutPackagePrefix() + hash, name.toString(), new String[]{InjectionPoint.class.getName()});
                try {
                    methodCreator.addAnnotation(Produces.class);
                    methodCreator.addAnnotation(FeatureVariant.class).add("name", (Object)"ignored");
                    ResultHandle unleashObj = methodCreator.readInstanceField(unleash.getFieldDescriptor(), methodCreator.getThis());
                    ResultHandle mapperObj = methodCreator.readInstanceField(mapper.getFieldDescriptor(), methodCreator.getThis());
                    ResultHandle res = methodCreator.invokeSpecialMethod(MethodDescriptor.ofMethod(AbstractVariantProducer.class, (String)"getVariantJsonObject", Object.class, (Class[])new Class[]{InjectionPoint.class, Class.class, Unleash.class, UnleashJsonMapper.class}), methodCreator.getThis(), new ResultHandle[]{methodCreator.getMethodParam(0), methodCreator.loadClass(name.toString()), unleashObj, mapperObj});
                    methodCreator.returnValue(res);
                }
                finally {
                    if (methodCreator == null) continue;
                    methodCreator.close();
                }
            }
        }
    }
}

