/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.unleash;

import io.getunleash.ActivationStrategy;
import io.getunleash.Constraint;
import io.getunleash.DefaultUnleash;
import io.getunleash.FeatureToggle;
import io.getunleash.Operator;
import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.strategy.GradualRolloutRandomStrategy;
import io.getunleash.variant.Payload;
import io.getunleash.variant.VariantDefinition;
import io.getunleash.variant.VariantOverride;
import io.quarkiverse.unleash.runtime.UnleashRecorder;
import io.quarkiverse.unleash.runtime.UnleashRuntimeTimeConfig;
import io.quarkiverse.unleash.runtime.UnleashService;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.runtime.ApplicationConfig;

public class UnleashProcessor {
    private static final String FEATURE_NAME = "unleash";

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureRuntimeProperties(UnleashRecorder recorder, UnleashRuntimeTimeConfig runtimeConfig, ApplicationConfig appConfig) {
        recorder.initializeProducers(runtimeConfig, appConfig);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void nativeImageConfiguration(BuildProducer<ReflectiveClassBuildItem> reflective) {
        reflective.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{ClientRegistration.class.getName(), ClientMetrics.class.getName(), ActivationStrategy.class.getName(), Constraint.class.getName(), VariantDefinition.class.getName(), VariantOverride.class.getName(), Payload.class.getName(), Operator.class.getName(), FeatureToggle.class.getName(), ToggleCollection.class.getName()}));
    }

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<ExtensionSslNativeSupportBuildItem> ssl) {
        ssl.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(FEATURE_NAME));
        featureProducer.produce((BuildItem)new FeatureBuildItem(FEATURE_NAME));
    }

    @BuildStep
    void build(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(UnleashService.class));
    }

    @BuildStep
    NativeImageConfigBuildItem buildNativeImage() {
        NativeImageConfigBuildItem.Builder builder = NativeImageConfigBuildItem.builder();
        builder.addRuntimeInitializedClass(GradualRolloutRandomStrategy.class.getName());
        builder.addRuntimeInitializedClass(DefaultUnleash.class.getName());
        return builder.build();
    }
}

