/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaNetworkConfiguration;
import io.quarkus.runtime.util.StringUtil;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

class QuinoaDevWebSocketProxyHandler {
    private static final Logger LOG = Logger.getLogger(QuinoaDevWebSocketProxyHandler.class);
    private final HttpClient httpClient;
    private final QuinoaNetworkConfiguration networkConfiguration;

    QuinoaDevWebSocketProxyHandler(Vertx vertx, QuinoaNetworkConfiguration network) {
        this.httpClient = vertx.createHttpClient();
        this.networkConfiguration = network;
    }

    public void handle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        ctx.request().pause();
        request.toWebSocket(r -> {
            if (r.succeeded()) {
                String forwardUri = request.uri();
                LOG.debugf("Quinoa Dev WebSocket Server Connected: %s:%s%s", (Object)this.networkConfiguration.getHost(), (Object)this.networkConfiguration.getPort(), (Object)forwardUri);
                ServerWebSocket serverWs = (ServerWebSocket)r.result();
                AtomicReference clientWs = new AtomicReference();
                serverWs.exceptionHandler(e -> LOG.errorf(e, "Quinoa Dev WebSocket Server closed with error: %s", (Object)e.getMessage())).closeHandler(__ -> {
                    clientWs.getAndUpdate(w -> {
                        if (w != null && !w.isClosed()) {
                            w.close();
                        }
                        return null;
                    });
                    LOG.debug((Object)"Quinoa Dev WebSocket Server is closed");
                });
                String subProtocol = serverWs.subProtocol();
                ArrayList<String> subProtocols = new ArrayList<String>(1);
                if (!StringUtil.isNullOrEmpty((String)subProtocol)) {
                    subProtocols.add(subProtocol);
                    LOG.debugf("Quinoa Dev WebSocket SubProtocol: %s", (Object)subProtocol);
                }
                WebSocketConnectOptions options = new WebSocketConnectOptions().setHost(this.networkConfiguration.getHost()).setPort(this.networkConfiguration.getPort()).setURI(forwardUri).setHeaders(serverWs.headers()).setSubProtocols(subProtocols).setAllowOriginHeader(false);
                serverWs.accept();
                this.httpClient.webSocket(options, clientContext -> {
                    if (clientContext.succeeded()) {
                        LOG.infof("Quinoa Dev WebSocket Client Connected: %s:%s%s", (Object)this.networkConfiguration.getHost(), (Object)this.networkConfiguration.getPort(), (Object)forwardUri);
                        clientWs.set((WebSocket)clientContext.result());
                        ((WebSocket)clientWs.get()).exceptionHandler(e -> LOG.errorf(e, "Quinoa Dev WebSocket Client closed with error: %s", (Object)e.getMessage())).closeHandler(__ -> {
                            LOG.debug((Object)"Quinoa Dev WebSocket Client is closed");
                            serverWs.close();
                        }).textMessageHandler(msg -> {
                            LOG.debugf("Quinoa Dev WebSocket Client message: %s", msg);
                            serverWs.writeTextMessage(msg);
                        });
                        serverWs.textMessageHandler(msg -> {
                            LOG.debugf("Quinoa Dev WebSocket Server message:  %s", msg);
                            WebSocket w = (WebSocket)clientWs.get();
                            if (w != null && !w.isClosed()) {
                                w.writeTextMessage(msg);
                            }
                        });
                    } else {
                        LOG.error((Object)"Quinoa Dev WebSocket Client connection failed", clientContext.cause());
                    }
                });
            } else {
                LOG.error((Object)"Error while upgrading request to WebSocket", r.cause());
            }
        });
    }
}

