/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

class QuinoaUIResourceHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaUIResourceHandler.class);
    private final QuinoaHandlerConfig config;
    private final Set<String> uiResources;
    private final Handler<RoutingContext> handler;
    private final ClassLoader currentClassLoader;

    QuinoaUIResourceHandler(QuinoaHandlerConfig config, String directory, Set<String> uiResources) {
        this.config = config;
        this.uiResources = new HashSet<String>(uiResources.size());
        for (String uiResource : uiResources) {
            String encoded = QuinoaUIResourceHandler.encodeURI(uiResource);
            this.uiResources.add(encoded);
            LOG.debugf("Quinoa UI encoded: '%s'", (Object)encoded);
        }
        this.handler = QuinoaUIResourceHandler.createStaticHandler(config, directory);
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String path = QuinoaRecorder.resolvePath(ctx);
        if (QuinoaRecorder.isIgnored(path, this.config.ignoredPathPrefixes)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String resourcePath = path.endsWith("/") ? path + this.config.indexPage : path;
        LOG.debugf("Quinoa is checking: '%s'", (Object)resourcePath);
        if (!QuinoaRecorder.isIgnored(resourcePath, this.config.ignoredPathPrefixes) && this.uiResources.contains(resourcePath)) {
            LOG.debugf("Quinoa is serving: '%s'", (Object)resourcePath);
            QuinoaRecorder.compressIfNeeded(this.config, ctx, resourcePath);
            this.handler.handle((Object)ctx);
        } else {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
    }

    private static Handler<RoutingContext> createStaticHandler(QuinoaHandlerConfig config, String directory) {
        StaticHandler staticHandler = directory != null ? StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)directory) : StaticHandler.create((String)"META-INF/webui");
        staticHandler.setDefaultContentEncoding(StandardCharsets.UTF_8.name());
        staticHandler.setIndexPage(config.indexPage);
        staticHandler.setCachingEnabled(!config.devMode);
        return staticHandler;
    }

    private static String encodeURI(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2F", "/").replace("%7E", "~");
    }
}

