/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.jboss.logging.Logger;

class QuinoaSPARoutingHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaSPARoutingHandler.class);
    private final ClassLoader currentClassLoader;
    private final QuinoaHandlerConfig config;

    public QuinoaSPARoutingHandler(QuinoaHandlerConfig config) {
        this.config = config;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String path = QuinoaRecorder.resolvePath(ctx);
        if (!Objects.equals(path, "/") && !QuinoaRecorder.isIgnored(path, this.config.ignoredPathPrefixes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Quinoa is re-routing SPA request '%s' to '/'", (Object)ctx.normalizedPath());
            }
            ctx.reroute(ctx.mountPoint() != null ? ctx.mountPoint() : "/");
        } else {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
    }
}

