/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.List;
import org.jboss.logging.Logger;

class QuinoaDevProxyHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaDevProxyHandler.class);
    private final List<String> HEADERS_TO_FORWARD = List.of(HttpHeaders.ACCEPT_RANGES.toString(), HttpHeaders.CONTENT_RANGE.toString(), HttpHeaders.CONTENT_LENGTH.toString(), HttpHeaders.CONTENT_TYPE.toString());
    private final int port;
    private final WebClient client;
    private final ClassLoader currentClassLoader;
    private final QuinoaHandlerConfig config;

    QuinoaDevProxyHandler(QuinoaHandlerConfig config, Vertx vertx, int port) {
        this.port = port;
        this.client = WebClient.create((Vertx)vertx);
        this.config = config;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(final RoutingContext ctx) {
        String resourcePath;
        String path = QuinoaRecorder.resolvePath(ctx);
        if (QuinoaRecorder.isIgnored(path, this.config.ignoredPathPrefixes)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        final HttpServerRequest request = ctx.request();
        String string = resourcePath = path.endsWith("/") ? path + this.config.indexPage : path;
        if (QuinoaRecorder.isIgnored(resourcePath, this.config.ignoredPathPrefixes)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String uri = this.computeURI(resourcePath, request);
        MultiMap headers = request.headers();
        headers.remove("Accept");
        headers.remove("Accept-Encoding");
        this.client.request(request.method(), this.port, request.localAddress().host(), uri).putHeaders(headers).send((Handler)new Handler<AsyncResult<HttpResponse<Buffer>>>(){

            public void handle(AsyncResult<HttpResponse<Buffer>> event) {
                if (event.succeeded()) {
                    int statusCode = ((HttpResponse)event.result()).statusCode();
                    if (statusCode == 200) {
                        QuinoaDevProxyHandler.this.forwardResponse(event, request, ctx, resourcePath);
                    } else if (statusCode == 404) {
                        QuinoaRecorder.next(QuinoaDevProxyHandler.this.currentClassLoader, ctx);
                    } else {
                        QuinoaDevProxyHandler.this.forwardError(event, statusCode, ctx);
                    }
                } else {
                    QuinoaDevProxyHandler.this.error(event, ctx);
                }
            }
        });
    }

    private String computeURI(String path, HttpServerRequest request) {
        Object uri = path;
        String query = request.query();
        if (query != null) {
            uri = (String)uri + "?" + query;
        }
        return uri;
    }

    private void forwardError(AsyncResult<HttpResponse<Buffer>> event, int statusCode, RoutingContext ctx) {
        Buffer body = (Buffer)((HttpResponse)event.result()).body();
        HttpServerResponse response = ctx.response().setStatusCode(statusCode);
        if (body != null) {
            response.send(body);
        } else {
            response.send();
        }
    }

    private void forwardResponse(AsyncResult<HttpResponse<Buffer>> event, HttpServerRequest request, RoutingContext ctx, String resourcePath) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Quinoa is forwarding: '%s'", (Object)request.uri());
        }
        HttpServerResponse response = ctx.response();
        for (String header : this.HEADERS_TO_FORWARD) {
            response.headers().add(header, (Iterable)((HttpResponse)event.result()).headers().getAll(header));
        }
        QuinoaRecorder.compressIfNeeded(this.config, ctx, resourcePath);
        Buffer body = (Buffer)((HttpResponse)event.result()).body();
        if (body != null) {
            response.send(body);
        } else {
            response.send();
        }
    }

    private void error(AsyncResult<HttpResponse<Buffer>> event, RoutingContext ctx) {
        ctx.response().setStatusCode(500);
        ctx.response().send("Quinoa failed to forward request, see logs.");
        LOG.error((Object)"Quinoa failed to forward request, see logs.", event.cause());
    }
}

