/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.Objects;
import org.jboss.logging.Logger;

class QuinoaSPARoutingHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaSPARoutingHandler.class);
    private final List<String> ignoredPathPrefixes;
    private final ClassLoader currentClassLoader;

    public QuinoaSPARoutingHandler(List<String> ignoredPathPrefixes) {
        this.ignoredPathPrefixes = ignoredPathPrefixes;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        String path;
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
        if (!Objects.equals(path = QuinoaRecorder.resolvePath(ctx), "/") && !QuinoaRecorder.isIgnored(path, this.ignoredPathPrefixes)) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Quinoa is re-routing SPA request '%s' to '/'", (Object)ctx.normalizedPath());
            }
            ctx.reroute("/");
        } else {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
        }
    }
}

