/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FileSystemAccess;
import io.vertx.ext.web.handler.StaticHandler;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;

class QuinoaUIResourceHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaUIResourceHandler.class);
    private final Set<String> uiResources;
    private final Handler<RoutingContext> staticHandler;
    private final boolean enableSPARouting;
    private final ClassLoader currentClassLoader;

    QuinoaUIResourceHandler(String directory, Set<String> uiResources, boolean enableSPARouting) {
        this.uiResources = uiResources;
        this.staticHandler = directory != null ? StaticHandler.create((FileSystemAccess)FileSystemAccess.ROOT, (String)directory) : StaticHandler.create((String)"META-INF/webui");
        this.enableSPARouting = enableSPARouting;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        String rel;
        String string = ctx.mountPoint() == null ? ctx.normalizedPath() : (rel = ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length()));
        if (this.uiResources.contains(rel) || this.uiResources.contains("/index.html") && Objects.equals(rel, "/")) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Quinoa is serving: '%s'", (Object)rel);
            }
            this.staticHandler.handle((Object)ctx);
        } else if (this.enableSPARouting) {
            ctx.reroute("/");
        } else {
            Thread.currentThread().setContextClassLoader(this.currentClassLoader);
            ctx.next();
        }
    }
}

