/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import org.jboss.logging.Logger;

class QuinoaDevProxyHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaDevProxyHandler.class);
    private final Integer port;
    private final WebClient client;
    private final ClassLoader currentClassLoader;

    QuinoaDevProxyHandler(Vertx vertx, Integer port) {
        this.port = port;
        this.client = WebClient.create((Vertx)vertx);
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(final RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        this.client.request(request.method(), this.port.intValue(), request.localAddress().host(), request.uri()).send((Handler)new Handler<AsyncResult<HttpResponse<Buffer>>>(){

            public void handle(AsyncResult<HttpResponse<Buffer>> event) {
                if (event.succeeded()) {
                    int statusCode = ((HttpResponse)event.result()).statusCode();
                    if (statusCode == 200) {
                        ctx.response().headers().addAll(((HttpResponse)event.result()).headers());
                        ctx.response().send((Buffer)((HttpResponse)event.result()).body());
                    } else if (statusCode == 404) {
                        Thread.currentThread().setContextClassLoader(QuinoaDevProxyHandler.this.currentClassLoader);
                        ctx.next();
                    } else {
                        ctx.response().setStatusCode(statusCode).send((Buffer)((HttpResponse)event.result()).body());
                    }
                } else {
                    ctx.response().setStatusCode(500);
                    ctx.response().send();
                }
            }
        });
    }
}

