/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.quarkiverse.reactive.messsaging.nats.jetstream.tracing.JetStreamTrace;
import jakarta.annotation.Nullable;

public class JetStreamTraceAttributesExtractor
implements AttributesExtractor<JetStreamTrace, Void> {
    private static final String MESSAGE_PAYLOAD = "message.payload";
    private final MessagingAttributesGetter<JetStreamTrace, Void> messagingAttributesGetter = new JetStreamMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributesBuilder, Context context, JetStreamTrace jetStreamTrace) {
        attributesBuilder.put(MESSAGE_PAYLOAD, jetStreamTrace.payload());
    }

    public void onEnd(AttributesBuilder attributesBuilder, Context context, JetStreamTrace jetStreamTrace, @Nullable Void unused, @Nullable Throwable throwable) {
    }

    public MessagingAttributesGetter<JetStreamTrace, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    private static final class JetStreamMessagingAttributesGetter
    implements MessagingAttributesGetter<JetStreamTrace, Void> {
        private JetStreamMessagingAttributesGetter() {
        }

        public String getSystem(JetStreamTrace trace) {
            return "jetstream";
        }

        public String getDestination(JetStreamTrace trace) {
            return String.format("%s.%s", trace.stream(), trace.subject());
        }

        public boolean isTemporaryDestination(JetStreamTrace trace) {
            return false;
        }

        public String getConversationId(JetStreamTrace trace) {
            return null;
        }

        public Long getMessagePayloadSize(JetStreamTrace trace) {
            return null;
        }

        public Long getMessagePayloadCompressedSize(JetStreamTrace trace) {
            return null;
        }

        public String getMessageId(JetStreamTrace trace, Void unused) {
            return null;
        }
    }
}

