/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nats.client.Message;
import io.nats.client.api.MessageInfo;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Optional;
import org.jboss.logging.Logger;

@ApplicationScoped
public class PayloadMapper {
    private static final Logger logger = Logger.getLogger(PayloadMapper.class);
    public static final String MESSAGE_TYPE_HEADER = "message.type";
    private final ObjectMapper objectMapper;

    @Inject
    public PayloadMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] toByteArray(Object payload) {
        try {
            if (payload == null) {
                return new byte[0];
            }
            if (payload instanceof byte[]) {
                byte[] byteArray = (byte[])payload;
                return byteArray;
            }
            return this.objectMapper.writeValueAsBytes(payload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Optional<? super T> toPayload(Message message) {
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst(MESSAGE_TYPE_HEADER))).map(this::loadClass).map(type -> this.decode(message.getData(), (Class)type));
    }

    public <T> Optional<T> toPayload(MessageInfo message) {
        logger.infof("Getting payload from message info: %s", (Object)message);
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst(MESSAGE_TYPE_HEADER))).map(this::loadClass).map(type -> this.decode(message.getData(), (Class)type));
    }

    public <T> T toPayload(Message message, String type) {
        Class<T> payLoadType = this.loadClass(type);
        return this.decode(message.getData(), payLoadType);
    }

    private <T> T decode(byte[] data, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Class<T> loadClass(String type) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

