/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;

@TargetClass(value=EdDSAEngine.class)
public final class Target_EdDSAEngine {
    @Alias
    private MessageDigest digest;
    @Alias
    private ByteArrayOutputStream baos;
    @Alias
    private EdDSAKey key;
    @Alias
    private boolean oneShotMode;
    @Alias
    private byte[] oneShotBytes;

    @Substitute
    private void reset() {
        if (this.digest != null) {
            this.digest.reset();
        }
        if (this.baos != null) {
            this.baos.reset();
        }
        this.oneShotMode = false;
        this.oneShotBytes = null;
    }

    @Substitute
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.reset();
        if (publicKey instanceof EdDSAPublicKey) {
            this.key = (EdDSAPublicKey)publicKey;
            if (this.digest == null) {
                try {
                    this.digest = MessageDigest.getInstance(this.key.getParams().getHashAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new InvalidKeyException("cannot get required digest " + this.key.getParams().getHashAlgorithm() + " for private key.");
                }
            } else if (!this.key.getParams().getHashAlgorithm().equals(this.digest.getAlgorithm())) {
                throw new InvalidKeyException("Key hash algorithm does not match chosen digest");
            }
        } else if (publicKey.getFormat().equals("X.509")) {
            EdDSAPublicKey parsedPublicKey;
            try {
                parsedPublicKey = new EdDSAPublicKey(new X509EncodedKeySpec(publicKey.getEncoded()));
            }
            catch (InvalidKeySpecException ex) {
                throw new InvalidKeyException("cannot handle X.509 EdDSA public key: " + publicKey.getAlgorithm());
            }
            this.engineInitVerify((PublicKey)parsedPublicKey);
        } else {
            throw new InvalidKeyException("cannot identify EdDSA public key: " + publicKey.getClass());
        }
    }
}

