/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.client;

import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.ConnectionConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.DefaultErrorListener;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class JetStreamClient
implements AutoCloseable {
    private final ConnectionConfiguration configuration;
    private final Vertx vertx;
    private final AtomicReference<Connection> connection;

    public JetStreamClient(ConnectionConfiguration configuration, Vertx vertx) {
        this.vertx = vertx;
        this.configuration = configuration;
        this.connection = new AtomicReference();
    }

    public JetStreamClient(ConnectionConfiguration configuration) {
        this(configuration, null);
    }

    public Uni<Connection> getOrEstablishConnection() {
        return Uni.createFrom().item(() -> Optional.ofNullable(this.connection.get()).filter(this::isConnected).orElse(null)).onItem().ifNull().switchTo(this::connect).onItem().invoke(this.connection::set);
    }

    public Optional<Connection> getConnection() {
        return Optional.ofNullable(this.connection.get());
    }

    public Optional<Vertx> getVertx() {
        return Optional.ofNullable(this.vertx);
    }

    private Uni<Connection> connect() {
        return this.getVertx().map(v -> this.connectWithContext(v.getOrCreateContext())).orElseGet(this::connectWithoutContext);
    }

    private Uni<Connection> connectWithContext(Context context) {
        return Uni.createFrom().emitter(em -> {
            try {
                Options options = this.createConnectionOptions(this.configuration, (connection, type) -> {
                    if (ConnectionListener.Events.CONNECTED.equals((Object)type)) {
                        em.complete((Object)new Connection(connection, context));
                    }
                });
                Nats.connectAsynchronously((Options)options, (boolean)true);
            }
            catch (InterruptedException | NoSuchAlgorithmException e) {
                em.fail((Throwable)e);
            }
        }).emitOn(arg_0 -> ((Context)context).runOnContext(arg_0));
    }

    private Uni<Connection> connectWithoutContext() {
        return Uni.createFrom().emitter(em -> {
            try {
                Options options = this.createConnectionOptions(this.configuration, (connection, type) -> {
                    if (ConnectionListener.Events.CONNECTED.equals((Object)type)) {
                        em.complete((Object)new Connection(connection, null));
                    }
                });
                Nats.connectAsynchronously((Options)options, (boolean)true);
            }
            catch (InterruptedException | NoSuchAlgorithmException e) {
                em.fail((Throwable)e);
            }
        });
    }

    private boolean isConnected(Connection connection) {
        return connection != null && connection.isConnected();
    }

    private Options createConnectionOptions(ConnectionConfiguration configuration, ConnectionListener connectionListener) throws NoSuchAlgorithmException {
        String[] servers = configuration.getServers().split(",");
        Options.Builder optionsBuilder = new Options.Builder();
        optionsBuilder.servers(servers);
        optionsBuilder.maxReconnects(configuration.getMaxReconnects().orElse(-1).intValue());
        optionsBuilder.connectionListener(connectionListener);
        optionsBuilder.errorListener(this.getErrorListener(configuration));
        optionsBuilder.userInfo((String)configuration.getUsername().orElse(null), (String)configuration.getPassword().orElse(null));
        configuration.getBufferSize().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).bufferSize(arg_0));
        configuration.getConnectionTimeout().ifPresent(connectionTimeout -> optionsBuilder.connectionTimeout(Duration.ofMillis(connectionTimeout)));
        if (configuration.sslEnabled()) {
            optionsBuilder.opentls();
        }
        return optionsBuilder.build();
    }

    private ErrorListener getErrorListener(ConnectionConfiguration configuration) {
        return configuration.getErrorListener().orElseGet(DefaultErrorListener::new);
    }

    @Override
    public void close() {
        if (this.connection.get() != null) {
            this.connection.get().close();
        }
    }
}

