/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.client;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.support.Status;
import org.jboss.logging.Logger;

public class DefaultErrorListener
implements ErrorListener {
    private static final Logger logger = Logger.getLogger(DefaultErrorListener.class);

    public void errorOccurred(Connection conn, String error) {
        logger.warnf("Error occurred: %s", (Object)error);
    }

    public void exceptionOccurred(Connection conn, Exception exp) {
        logger.warnf("Caught exception connecting to %s with message: %s", (Object)conn.getServers(), (Object)exp.getMessage());
    }

    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        logger.warn((Object)"Slow consumer detected");
    }

    public void messageDiscarded(Connection conn, Message msg) {
        logger.warnf("Message with id = %s discarded", (Object)msg.getSID());
    }

    public void unhandledStatus(Connection conn, JetStreamSubscription sub, Status status) {
        logger.warnf("Unhandled status: %s", (Object)status);
    }

    public void pullStatusWarning(Connection conn, JetStreamSubscription sub, Status status) {
        logger.warnf("Pull status warning with status: %s", (Object)status);
    }

    public void pullStatusError(Connection conn, JetStreamSubscription sub, Status status) {
        logger.errorf("Pull status error with status: %s", (Object)status);
    }
}

