/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.client;

import io.nats.client.ErrorListener;
import io.quarkiverse.reactive.messsaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.ConnectionConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

class DefaultConnectionConfiguration
implements ConnectionConfiguration {
    private final NatsConfiguration configuration;

    DefaultConnectionConfiguration(NatsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getServers() {
        return this.configuration.servers();
    }

    @Override
    public Optional<String> getPassword() {
        return this.configuration.password();
    }

    @Override
    public Optional<String> getUsername() {
        return this.configuration.username();
    }

    @Override
    public Optional<Integer> getMaxReconnects() {
        return this.configuration.maxReconnects();
    }

    @Override
    public boolean sslEnabled() {
        return this.configuration.sslEnabled();
    }

    @Override
    public Optional<Integer> getBufferSize() {
        return this.configuration.bufferSize();
    }

    @Override
    public Optional<ErrorListener> getErrorListener() {
        return this.configuration.errorListener().map(this::getInstanceOfErrorListener);
    }

    @Override
    public Optional<Long> getConnectionTimeout() {
        return this.configuration.connectionTimeout();
    }

    private ErrorListener getInstanceOfErrorListener(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (ErrorListener)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Not able to create instance of error listener", e);
        }
    }
}

