/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream.administration;

import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.StreamContext;
import io.nats.client.api.MessageInfo;
import io.quarkiverse.reactive.messsaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.administration.JetStreamMessage;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.ConnectionConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.JetStreamClient;
import io.quarkiverse.reactive.messsaging.nats.jetstream.mapper.PayloadMapper;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MessageResolver {
    private static final Logger logger = Logger.getLogger(MessageResolver.class);
    private final NatsConfiguration configuration;
    private final PayloadMapper payloadMapper;
    private final ExecutionHolder executionHolder;

    @Inject
    public MessageResolver(NatsConfiguration configuration, PayloadMapper payloadMapper, ExecutionHolder executionHolder) {
        this.configuration = configuration;
        this.payloadMapper = payloadMapper;
        this.executionHolder = executionHolder;
    }

    public <T> Uni<Message<T>> resolve(String streamName, long sequence) {
        JetStreamClient client = new JetStreamClient(ConnectionConfiguration.of(this.configuration), this.executionHolder.vertx());
        return client.getOrEstablishConnection().onItem().transformToUni(connection -> this.resolve((Connection)connection, streamName, sequence)).onItem().invoke(m -> client.close()).onFailure().invoke(throwable -> {
            logger.errorf(throwable, "Failed to resolve message: %s", (Object)throwable.getMessage());
            client.close();
        });
    }

    private <T> Uni<Message<T>> resolve(Connection connection, String streamName, long sequence) {
        return Uni.createFrom().emitter(emitter -> {
            try {
                JetStream jetStream = connection.jetStream();
                StreamContext streamContext = jetStream.getStreamContext(streamName);
                MessageInfo messageInfo = streamContext.getMessage(sequence);
                emitter.complete(new JetStreamMessage<Object>(messageInfo, this.payloadMapper.toPayload(messageInfo).orElse(null)));
            }
            catch (JetStreamApiException | IOException e) {
                emitter.fail(e);
            }
        });
    }
}

