/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream;

import io.quarkiverse.reactive.messsaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.ConnectionConfiguration;
import io.quarkiverse.reactive.messsaging.nats.jetstream.client.JetStreamClient;
import io.quarkiverse.reactive.messsaging.nats.jetstream.setup.JetStreamSetup;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.time.Duration;
import org.jboss.logging.Logger;

@Recorder
public class JetStreamRecorder {
    private static final Logger logger = Logger.getLogger(JetStreamRecorder.class);
    private final JetStreamSetup jetStreamSetup = new JetStreamSetup();
    private final RuntimeValue<NatsConfiguration> natsConfiguration;
    private final RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration;

    public JetStreamRecorder(RuntimeValue<NatsConfiguration> natsConfiguration, RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration) {
        this.natsConfiguration = natsConfiguration;
        this.jetStreamConfiguration = jetStreamConfiguration;
    }

    public void setupStreams() {
        logger.info((Object)"Setup JetStream");
        try (JetStreamClient jetStreamClient = new JetStreamClient(ConnectionConfiguration.of((NatsConfiguration)this.natsConfiguration.getValue()));){
            Connection connection = (Connection)jetStreamClient.getOrEstablishConnection().await().atMost(Duration.ofSeconds(30L));
            this.jetStreamSetup.setup(connection, (JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue());
        }
    }
}

