/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream;

import io.nats.client.Message;
import io.nats.client.impl.Headers;
import io.smallrye.common.constraint.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JetStreamIncomingMessageMetadata {
    private final String stream;
    private final String subject;
    private final String messageId;
    private final Map<String, List<String>> headers;
    private final long deliveredCount;

    public JetStreamIncomingMessageMetadata(String stream, String subject, String messageId, Map<String, List<String>> headers, long deliveredCount) {
        this.stream = stream;
        this.subject = subject;
        this.messageId = messageId;
        this.headers = headers;
        this.deliveredCount = deliveredCount;
    }

    public String stream() {
        return this.stream;
    }

    public String subject() {
        return this.subject;
    }

    public String messageId() {
        return this.messageId;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public long deliveredCount() {
        return this.deliveredCount;
    }

    public static JetStreamIncomingMessageMetadata create(@NotNull Message message) {
        Optional<Headers> headers = Optional.ofNullable(message.getHeaders());
        return new JetStreamIncomingMessageMetadata(message.metaData().getStream(), message.getSubject(), headers.map(h -> h.getFirst("Nats-Msg-Id")).orElse(null), headers.map(JetStreamIncomingMessageMetadata::headers).orElseGet(HashMap::new), message.metaData().deliveredCount());
    }

    public static Map<String, List<String>> headers(Headers messageHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        messageHeaders.entrySet().forEach(entry -> headers.put((String)entry.getKey(), (List)entry.getValue()));
        return headers;
    }

    public String toString() {
        return "JetStreamIncomingMessageMetadata{stream='" + this.stream + "', subject='" + this.subject + "', messageId='" + this.messageId + "', headers=" + this.headers + ", deliveredCount=" + this.deliveredCount + "}";
    }
}

