/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream;

import io.nats.client.Message;
import io.quarkiverse.reactive.messsaging.nats.jetstream.JetStreamIncomingMessageMetadata;
import io.quarkiverse.reactive.messsaging.nats.jetstream.JetStreamMessage;
import io.quarkiverse.reactive.messsaging.nats.jetstream.mapper.HeaderMapper;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class JetStreamIncomingMessage<T>
implements JetStreamMessage<T> {
    private final Message message;
    private Metadata metadata;
    private final JetStreamIncomingMessageMetadata incomingMetadata;
    private final T payload;
    private final io.vertx.mutiny.core.Context context;

    public JetStreamIncomingMessage(Message message, T payload, io.vertx.mutiny.core.Context context) {
        this.message = message;
        this.incomingMetadata = JetStreamIncomingMessageMetadata.create(message);
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{this.incomingMetadata, new LocalContextMetadata(io.smallrye.common.vertx.VertxContext.createNewDuplicatedContext((Context)context.getDelegate()))});
        this.payload = payload;
        this.context = context;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getMessageId() {
        return this.incomingMetadata.messageId();
    }

    public byte[] getData() {
        return this.message.getData();
    }

    public String getSubject() {
        return this.incomingMetadata.subject();
    }

    public String getStream() {
        return this.incomingMetadata.stream();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return HeaderMapper.toMessageHeaders(this.message.getHeaders());
    }

    public T getPayload() {
        return this.payload;
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public CompletionStage<Void> ack() {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            this.message.ack();
            this.runOnMessageContext(() -> f.complete(null));
        });
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        return VertxContext.runOnContext((Context)this.context.getDelegate(), f -> {
            this.message.nak();
            this.runOnMessageContext(() -> f.completeExceptionally(reason));
        });
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return arg_0 -> ((JetStreamIncomingMessage)this).nack(arg_0);
    }

    public synchronized void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }

    public org.eclipse.microprofile.reactive.messaging.Message<T> addMetadata(Object metadata) {
        this.injectMetadata(metadata);
        return this;
    }

    public String toString() {
        return "IncomingNatsMessage{metadata=" + this.incomingMetadata + ", payload=" + this.payload + "}";
    }
}

