/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messsaging.nats.jetstream;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class JetStreamConnectorCommonConfiguration {
    protected final Config config;

    public JetStreamConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getStream() {
        return this.config.getOptionalValue("stream", String.class);
    }

    public Optional<String> getSubject() {
        return this.config.getOptionalValue("subject", String.class);
    }

    public Boolean getTraceEnabled() {
        return this.config.getOptionalValue("trace-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getAutoConfigure() {
        return this.config.getOptionalValue("auto-configure", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public void validate() {
    }
}

