package io.quarkiverse.reactive.messsaging.nats.jetstream;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the incoming configuration for the {@code quarkus-jetstream} connector.
*/
public class JetStreamConnectorIncomingConfiguration extends JetStreamConnectorCommonConfiguration {

  /**
   * Creates a new JetStreamConnectorIncomingConfiguration.
   */
  public JetStreamConnectorIncomingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the ordered value from the configuration.
  * Attribute Name: ordered
  * Description: Flag indicating whether this subscription should be ordered
  * @return the ordered
  */
  public Optional<Boolean> getOrdered() {
    return config.getOptionalValue("ordered", Boolean.class);
  }

  /**
  * Gets the deliver-group value from the configuration.
  * Attribute Name: deliver-group
  * Description: The optional deliver group to join
  * @return the deliver-group
  */
  public Optional<String> getDeliverGroup() {
    return config.getOptionalValue("deliver-group", String.class);
  }

  /**
  * Gets the durable value from the configuration.
  * Attribute Name: durable
  * Description: Sets the durable name for the consumer
  * @return the durable
  */
  public Optional<String> getDurable() {
    return config.getOptionalValue("durable", String.class);
  }

  /**
  * Gets the max-deliver value from the configuration.
  * Attribute Name: max-deliver
  * Description: The maximum number of times a specific message delivery will be attempted
  * Default Value: 1
  * @return the max-deliver
  */
  public Long getMaxDeliver() {
    return config.getOptionalValue("max-deliver", Long.class)
     .orElse(Long.valueOf("1"));
  }

  /**
  * Gets the back-off value from the configuration.
  * Attribute Name: back-off
  * Description: The timing of re-deliveries as a comma-separated list of durations
  * @return the back-off
  */
  public Optional<String> getBackOff() {
    return config.getOptionalValue("back-off", String.class);
  }

  /**
  * Gets the payload-type value from the configuration.
  * Attribute Name: payload-type
  * Description: The payload type
  * @return the payload-type
  */
  public Optional<String> getPayloadType() {
    return config.getOptionalValue("payload-type", String.class);
  }

  public void validate() {
    super.validate();
  }
}
