/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quarkus.mongock.deployment;

import com.mongodb.client.MongoClient;
import io.mongock.api.annotations.ChangeUnit;
import io.quarkiverse.quarkus.mongock.MongockFactory;
import io.quarkiverse.quarkus.mongock.deployment.MongockEnabled;
import io.quarkiverse.quarkus.mongock.runtime.MongockRecorder;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.InitTaskBuildItem;
import io.quarkus.deployment.builditem.InitTaskCompletedBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.mongodb.runtime.MongodbConfig;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={MongockEnabled.class})
class MongockProcessor {
    MongockProcessor() {
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(MongockRecorder recorder, CombinedIndexBuildItem combinedIndex, RecorderContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        ArrayList migrationClasses = new ArrayList();
        this.addMigrationClasses(combinedIndex, context, reflectiveClassProducer, migrationClasses);
        recorder.setMigrationClasses(migrationClasses);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBeans(MongockRecorder recorder, MongodbConfig mongodbConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MongockFactory.class).scope(Singleton.class)).setRuntimeInit().unremovable()).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(MongoClient.class)), new AnnotationInstance[0])).createWith(recorder.mongockFunction(mongodbConfig));
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
    }

    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem startLiquibase(MongockRecorder recorder, BuildProducer<InitTaskCompletedBuildItem> initializationCompleteBuildItem) {
        recorder.doStartActions();
        initializationCompleteBuildItem.produce((BuildItem)new InitTaskCompletedBuildItem("mongock"));
        return new ServiceStartBuildItem("mongock");
    }

    @BuildStep
    public InitTaskBuildItem configureInitTask(ApplicationInfoBuildItem app) {
        return InitTaskBuildItem.create().withName(app.getName() + "-mongock-init").withTaskEnvVars(Map.of("QUARKUS_INIT_AND_EXIT", "true", "QUARKUS_MONGOCK_ENABLED", "true")).withAppEnvVars(Map.of("QUARKUS_MONGOCK_ENABLED", "false")).withSharedEnvironment(true).withSharedFilesystem(true);
    }

    private void addMigrationClasses(CombinedIndexBuildItem combinedIndex, RecorderContext context, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, List<Class<?>> migrationClasses) {
        combinedIndex.getIndex().getAnnotations(DotName.createSimple((String)ChangeUnit.class.getName())).stream().map(annotationInstance -> annotationInstance.target().asClass()).forEach(classInfo -> {
            migrationClasses.add(context.classProxy(classInfo.name().toString()));
            reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{classInfo.name().toString()}).methods().build());
        });
    }
}

