/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quarkus.elasticsearch.reactive.deployment;

import io.quarkiverse.quarkus.elasticsearch.reactive.deployment.ElasticsearchReactiveBuildTimeConfig;
import io.quarkiverse.quarkus.elasticsearch.reactive.runtime.ElasticsearchReactiveProducer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.elasticsearch.restclient.lowlevel.ElasticsearchClientConfig;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import org.jboss.jandex.DotName;

class ElasticsearchReactiveProcessor {
    private static final DotName ELASTICSEARCH_CLIENT_CONFIG = DotName.createSimple((String)ElasticsearchClientConfig.class.getName());
    private static final String FEATURE = "elasticsearch-reactive";

    ElasticsearchReactiveProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalBeanBuildItem build() {
        return AdditionalBeanBuildItem.unremovableOf(ElasticsearchReactiveProducer.class);
    }

    @BuildStep
    void elasticsearchClientConfigSupport(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ElasticsearchClientConfig.class).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ELASTICSEARCH_CLIENT_CONFIG, DotNames.APPLICATION_SCOPED, false));
    }

    @BuildStep
    HealthBuildItem addHealthCheck(ElasticsearchReactiveBuildTimeConfig buildTimeConfig) {
        return new HealthBuildItem("io.quarkiverse.quarkus.elasticsearch.reactive.runtime.health.ElasticsearchReactiveHealthCheck", buildTimeConfig.healthEnabled);
    }
}

