/*
 * Decompiled with CFR 0.152.
 */
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.LambdaDsl;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.junit5.PactConsumerTestExt;
import au.com.dius.pact.consumer.junit5.PactTestFor;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.annotations.Pact;
import au.com.dius.pact.core.model.annotations.PactDirectory;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={PactConsumerTestExt.class})
@PactTestFor(providerName="farm", port="8085")
@PactDirectory(value="target/pacts")
@QuarkusTest
public class ConsumerTest {
    @Inject
    Knitter knitter;

    @Pact(provider="farm", consumer="knitter")
    public V4Pact createPact(PactDslWithProvider builder) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        DslPart requestBody = LambdaDsl.newJsonBody(body -> body.stringType("colour").numberType(new String[]{"orderNumber"})).build();
        DslPart woolResponseBody = LambdaDsl.newJsonBody(body -> body.stringValue("colour", "white")).build();
        return (V4Pact)builder.uponReceiving("post request").path("/wool/order").headers(headers).method("POST").body(requestBody).willRespondWith().status(Response.Status.OK.getStatusCode()).headers(headers).body(woolResponseBody).toPact(V4Pact.class);
    }

    @Test
    public void testConsumption() {
        String knitted = this.knitter.knit("irrelevant");
        Assertions.assertEquals((Object)"a nice striped sweater", (Object)knitted);
    }
}

