/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opencv.deployment;

import io.quarkiverse.opencv.deployment.OpenCVLibraryUtil;
import io.quarkiverse.opencv.runtime.OpenCVRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.io.IOException;

class OpenCVProcessor {
    private static final String FEATURE = "opencv";

    OpenCVProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void nativeJni(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, NativeImageRunnerBuildItem nativeImageRunner) throws IOException {
        if (nativeImageRunner.isContainerBuild()) {
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{OpenCVLibraryUtil.extractNativeBinary(OpenCVLibraryUtil.OS.LINUX, OpenCVLibraryUtil.Arch.X86_64).substring(1)}));
        } else {
            nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{OpenCVLibraryUtil.extractNativeBinary(OpenCVLibraryUtil.OS.getCurrent(), OpenCVLibraryUtil.Arch.getCurrent()).substring(1)}));
        }
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("nu.pattern.OpenCV"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("nu.pattern.OpenCV$SharedLoader"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("nu.pattern.OpenCV$LocalLoader"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("nu.pattern.OpenCV$LocalLoader$Holder"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void loadOpenCV(OpenCVRecorder recorder) {
        recorder.loadOpenCVLibrary();
    }
}

