/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opencv.deployment;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class OpenCVLibraryUtil {
    public static String extractNativeBinary(OS os, Arch arch) {
        String location;
        block0 : switch (os) {
            case LINUX: {
                switch (arch) {
                    case X86_64: {
                        location = "/nu/pattern/opencv/linux/x86_64/libopencv_java481.so";
                        break block0;
                    }
                    case ARMv7: {
                        location = "/nu/pattern/opencv/linux/ARMv7/libopencv_java481.so";
                        break block0;
                    }
                    case ARMv8: {
                        location = "/nu/pattern/opencv/linux/ARMv8/libopencv_java481.so";
                        break block0;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case OSX: {
                switch (arch) {
                    case X86_64: {
                        location = "/nu/pattern/opencv/osx/x86_64/libopencv_java481.dylib";
                        break block0;
                    }
                    case ARMv8: {
                        location = "/nu/pattern/opencv/osx/ARMv8/libopencv_java481.dylib";
                        break block0;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            case WINDOWS: {
                switch (arch) {
                    case X86_32: {
                        location = "/nu/pattern/opencv/windows/x86_32/opencv_java481.dll";
                        break block0;
                    }
                    case X86_64: {
                        location = "/nu/pattern/opencv/windows/x86_64/opencv_java481.dll";
                        break block0;
                    }
                }
                throw new UnsupportedPlatformException(os, arch);
            }
            default: {
                throw new UnsupportedPlatformException(os, arch);
            }
        }
        return location;
    }

    private static class UnsupportedPlatformException
    extends RuntimeException {
        private UnsupportedPlatformException(OS os, Arch arch) {
            super(String.format("Operating system \"%s\" and architecture \"%s\" are not supported by OpenCV.", new Object[]{os, arch}));
        }
    }

    static enum Arch {
        X86_32("i386", "i686", "x86"),
        X86_64("amd64", "x86_64"),
        ARMv7("arm"),
        ARMv8("aarch64", "arm64");

        private final Set<String> patterns;

        private Arch(String ... patterns) {
            this.patterns = new HashSet<String>(Arrays.asList(patterns));
        }

        private boolean is(String id) {
            return this.patterns.contains(id);
        }

        public static Arch getCurrent() {
            String osArch = System.getProperty("os.arch");
            for (Arch arch : Arch.values()) {
                if (!arch.is(osArch)) continue;
                return arch;
            }
            throw new UnsupportedOperationException(String.format("Architecture \"%s\" is not supported.", osArch));
        }
    }

    static enum OS {
        OSX("^[Mm]ac OS X$"),
        LINUX("^[Ll]inux$"),
        WINDOWS("^[Ww]indows.*");

        private final Set<Pattern> patterns = new HashSet<Pattern>();

        private OS(String ... patterns) {
            for (String pattern : patterns) {
                this.patterns.add(Pattern.compile(pattern));
            }
        }

        private boolean is(String id) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(id).matches()) continue;
                return true;
            }
            return false;
        }

        public static OS getCurrent() {
            String osName = System.getProperty("os.name");
            for (OS os : OS.values()) {
                if (!os.is(osName)) continue;
                return os;
            }
            throw new UnsupportedOperationException(String.format("Operating system \"%s\" is not supported.", osName));
        }
    }
}

